/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.block;

import cofh.api.block.IDismantleable;
import com.yogpc.qp.Config;
import com.yogpc.qp.QuarryPlusI;
import com.yogpc.qp.block.ADismCBlock;
import com.yogpc.qp.packet.PacketHandler;
import com.yogpc.qp.packet.controller.AvailableEntities;
import com.yogpc.qp.version.VersionUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import scala.Symbol;

@Optional.Interface(iface="cofh.api.block.IDismantleable", modid="cofhcore")
public class BlockController
extends Block
implements IDismantleable {
    private static final Field logic_spawnDelay = ObfuscationReflectionHelper.findField(MobSpawnerBaseLogic.class, (String)"field_98286_b");
    public static final Symbol SYMBOL = Symbol.apply((String)"SpawnerController");
    public final ItemBlock itemBlock;

    public BlockController() {
        super(Material.field_151594_q);
        this.func_149663_c("spawnercontroller");
        this.setRegistryName("quarryplus", "spawnercontroller");
        this.func_149711_c(1.0f);
        this.func_149647_a(QuarryPlusI.creativeTab());
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)ADismCBlock.ACTING, (Comparable)Boolean.valueOf(false)));
        this.itemBlock = new ItemBlock((Block)this);
        this.itemBlock.setRegistryName("quarryplus", "spawnercontroller");
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ADismCBlock.ACTING});
    }

    private static Optional<MobSpawnerBaseLogic> getSpawner(World world, BlockPos pos) {
        return Stream.of(EnumFacing.field_82609_l).map(arg_0 -> ((BlockPos)pos).func_177972_a(arg_0)).map(arg_0 -> ((World)world).func_175625_s(arg_0)).filter(TileEntityMobSpawner.class::isInstance).map(tileEntity -> ((TileEntityMobSpawner)tileEntity).func_145881_a()).findFirst();
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ)) {
            return true;
        }
        if (!playerIn.func_70093_af()) {
            if (!worldIn.field_72995_K) {
                if (!Config.content().disableMapJ().get(SYMBOL).booleanValue()) {
                    List<EntityEntry> entries = ForgeRegistries.ENTITIES.getValuesCollection().stream().filter(entity -> entity.getEntityClass() != null && !Modifier.isAbstract(entity.getEntityClass().getModifiers()) && !Config.content().spawnerBlacklist().contains(entity.getRegistryName())).collect(Collectors.toList());
                    PacketHandler.sendToClient(AvailableEntities.create(pos, worldIn.field_73011_w.getDimension(), entries), (EntityPlayerMP)playerIn);
                } else {
                    VersionUtil.sendMessage(playerIn, (ITextComponent)new TextComponentString("Spawner Controller is disabled."), true);
                }
            }
            return true;
        }
        return false;
    }

    public static void setSpawnerEntity(World world, BlockPos pos, ResourceLocation name) {
        BlockController.getSpawner(world, pos).ifPresent(logic -> {
            if (!Config.content().spawnerBlacklist().contains(name)) {
                logic.func_190894_a(name);
            }
            Optional.ofNullable(logic.func_98271_a().func_175625_s(logic.func_177221_b())).ifPresent(TileEntity::func_70296_d);
            IBlockState state = logic.func_98271_a().func_180495_p(logic.func_177221_b());
            logic.func_98271_a().func_184138_a(logic.func_177221_b(), state, state, 3);
        });
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!worldIn.field_72995_K && !Config.content().disableMapJ().get(SYMBOL).booleanValue()) {
            boolean r = worldIn.func_175640_z(pos);
            boolean m = (Boolean)state.func_177229_b((IProperty)ADismCBlock.ACTING);
            if (r && !m) {
                BlockController.getSpawner(worldIn, pos).ifPresent(logic -> {
                    try {
                        logic_spawnDelay.setInt(logic, 0);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                        return;
                    }
                    FakePlayer fakePlayer = FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)worldIn));
                    fakePlayer.func_70029_a(logic.func_98271_a());
                    fakePlayer.func_70107_b((double)logic.func_177221_b().func_177958_n(), (double)logic.func_177221_b().func_177956_o(), (double)logic.func_177221_b().func_177952_p());
                    logic.func_98271_a().field_73010_i.add(fakePlayer);
                    logic.func_98278_g();
                    logic.func_98271_a().field_73010_i.remove(fakePlayer);
                });
                worldIn.func_175656_a(pos, state.func_177226_a((IProperty)ADismCBlock.ACTING, (Comparable)Boolean.valueOf(true)));
            } else if (!r && m) {
                worldIn.func_175656_a(pos, state.func_177226_a((IProperty)ADismCBlock.ACTING, (Comparable)Boolean.valueOf(false)));
            }
        }
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)ADismCBlock.ACTING, (Comparable)Boolean.valueOf(meta == 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)ADismCBlock.ACTING) != false ? 1 : 0;
    }

    @Optional.Method(modid="cofhcore")
    public ArrayList<ItemStack> dismantleBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player, boolean returnDrops) {
        return ADismCBlock.dismantle(world, pos, state, returnDrops);
    }

    @Optional.Method(modid="cofhcore")
    public boolean canDismantle(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return true;
    }
}

