/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.block;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.QuarryPlusI;
import com.yogpc.qp.block.ADismCBlock;
import com.yogpc.qp.compat.BuildcraftHelper;
import com.yogpc.qp.item.ItemBlockEnchantable;
import com.yogpc.qp.item.ItemTool;
import com.yogpc.qp.tile.IEnchantableTile;
import com.yogpc.qp.tile.TileQuarry2;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import jp.t2v.lab.syntax.MapStreamSyntax;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockQuarry2
extends ADismCBlock {
    public BlockQuarry2() {
        super(Material.field_151573_f, "quarry", ItemBlockEnchantable::new);
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)ACTING, (Comparable)Boolean.valueOf(false)));
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (!worldIn.field_72995_K) {
            EnumFacing facing = placer.func_174811_aO().func_176734_d();
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)facing), 2);
            Consumer consumer = IEnchantableTile.Util.initConsumer(stack);
            Optional.ofNullable(worldIn.func_175625_s(pos)).flatMap(MapStreamSyntax.optCast(TileQuarry2.class)).ifPresent(consumer.andThen(TileQuarry2.requestTicket));
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!worldIn.field_72995_K) {
            Optional.ofNullable(worldIn.func_175625_s(pos)).flatMap(MapStreamSyntax.optCast(TileQuarry2.class)).ifPresent(TileQuarry2::neighborChanged);
        }
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (super.func_180639_a(worldIn, pos, state, player, hand, side, hitX, hitY, hitZ)) {
            return true;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (BuildcraftHelper.isWrench(player, hand, stack, new RayTraceResult(new Vec3d((double)hitX, (double)hitY, (double)hitZ), side, pos))) {
            if (!worldIn.field_72995_K) {
                Optional.ofNullable((TileQuarry2)worldIn.func_175625_s(pos)).ifPresent(tileQuarry2 -> tileQuarry2.onActivated(player));
            }
            return true;
        }
        if (stack.func_77973_b() == QuarryPlusI.itemTool() && stack.func_77952_i() == ItemTool.meta_YSetter()) {
            player.openGui((Object)QuarryPlus.instance(), QuarryPlusI.guiIdQuarry2YLevel(), worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        if (stack.func_77973_b() == QuarryPlusI.itemTool() && stack.func_77952_i() == ItemTool.meta_StatusChecker()) {
            player.openGui((Object)QuarryPlus.instance(), QuarryPlusI.guiIdStatus(), worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        if (!player.func_70093_af()) {
            player.openGui((Object)QuarryPlus.instance(), QuarryPlusI.guiIdQuarryModule(), worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        return false;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity entity;
        if (!worldIn.field_72995_K && (entity = worldIn.func_175625_s(pos)) instanceof TileQuarry2) {
            TileQuarry2 inventory = (TileQuarry2)entity;
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)inventory.moduleInv());
            worldIn.func_175666_e(pos, state.func_177230_c());
        }
        super.func_180663_b(worldIn, pos, state);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, ACTING});
    }

    public int func_176201_c(IBlockState state) {
        boolean powered = (Boolean)state.func_177229_b((IProperty)ACTING);
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        return facing.func_176745_a() | (powered ? 8 : 0);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)(meta & 7))).func_177226_a((IProperty)ACTING, (Comparable)Boolean.valueOf((meta & 8) == 8));
    }

    @Override
    protected boolean canRotate() {
        return true;
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileQuarry2();
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, false);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        worldIn.func_175698_g(pos);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntity entity = world.func_175625_s(pos);
        if (entity instanceof TileQuarry2) {
            TileQuarry2 quarry = (TileQuarry2)entity;
            ItemStack stack = new ItemStack((Item)this.itemBlock(), 1, 0);
            IEnchantableTile.Util.enchantmentToIS(quarry, stack);
            drops.add((Object)stack);
        }
    }
}

