/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.compat;

import java.util.Optional;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class FluidStore {
    public static final boolean enabled = true;
    public static final long AMOUNT = 1000L;

    public static void injectToNearTile(World world, BlockPos pos, FluidStack fluid) {
        FluidStore.injectToNearTile(world, pos, fluid, 1000L);
    }

    public static long injectToNearTile(World world, BlockPos pos, FluidStack fluid, long amount) {
        if (!enabled) {
            return 0L;
        }
        return FluidStore.injectToNearTile_internal(world, pos, fluid, amount);
    }

    private static long injectToNearTile_internal(World world, BlockPos pos, FluidStack fluid, long amount) {
        FluidStack fluidKind = new FluidStack(fluid, (int)Math.max(Math.min(amount, Integer.MAX_VALUE), 0L));
        for (EnumFacing facing : EnumFacing.values()) {
            TileEntity entity = world.func_175625_s(pos.func_177972_a(facing));
            if (entity == null) continue;
            Optional<Object> capability = Optional.ofNullable(entity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d()));
            capability.ifPresent(tank -> {
                int filled = tank.fill(fluidKind, false);
                if (filled > 0) {
                    tank.fill(fluidKind, true);
                    fluidKind.amount -= filled;
                }
            });
            if (fluidKind.amount <= 0) break;
        }
        return amount - (long)fluidKind.amount;
    }
}

