/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.packet.distiller;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.packet.IMessage;
import com.yogpc.qp.tile.TileRefinery;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AnimationMessage
implements IMessage {
    public int dim;
    public BlockPos pos;
    public float speed;
    public int stage;

    public static AnimationMessage create(TileRefinery refinery) {
        AnimationMessage message = new AnimationMessage();
        message.pos = refinery.func_174877_v();
        message.dim = refinery.func_145831_w().field_73011_w.getDimension();
        message.speed = refinery.animationSpeed;
        message.stage = refinery.getAnimationStage();
        return message;
    }

    @Override
    public void fromBytes(PacketBuffer buffer) {
        this.pos = buffer.func_179259_c();
        this.dim = buffer.readInt();
        this.speed = buffer.readFloat();
        this.stage = buffer.readInt();
    }

    @Override
    public void toBytes(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos).writeInt(this.dim).writeFloat(this.speed).writeInt(this.stage);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IMessage onReceive(IMessage message, MessageContext ctx) {
        TileRefinery refinery;
        World world = QuarryPlus.proxy.getPacketWorld(ctx.netHandler);
        if (world.field_73011_w.getDimension() == this.dim && (refinery = (TileRefinery)world.func_175625_s(this.pos)) != null) {
            Minecraft.func_71410_x().func_152344_a(refinery.receiveMessage(this.stage, this.speed));
        }
        return null;
    }
}

