/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.packet.enchantment;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.packet.IMessage;
import com.yogpc.qp.tile.TileBasic;
import com.yogpc.qp.utils.BlockData;
import com.yogpc.qp.version.VersionUtil;
import java.io.IOException;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Enchantments;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class EnchantmentMessage
implements IMessage {
    Type type;
    BlockPos pos;
    int dim;
    Enchantment enchantment;
    BlockData data;

    public static EnchantmentMessage create(TileBasic tile, Type type, Enchantment enchantment, BlockData data) {
        EnchantmentMessage message = new EnchantmentMessage();
        message.pos = tile.func_174877_v();
        message.dim = tile.func_145831_w().field_73011_w.getDimension();
        message.type = type;
        message.enchantment = enchantment;
        message.data = data;
        return message;
    }

    @Override
    public void fromBytes(PacketBuffer buffer) throws IOException {
        this.pos = buffer.func_179259_c();
        this.type = (Type)buffer.func_179257_a(Type.class);
        this.enchantment = Enchantment.func_180305_b((String)buffer.func_150789_c(Short.MAX_VALUE));
        this.data = BlockData.readFromNBT(buffer.func_150793_b());
        this.dim = buffer.readInt();
    }

    @Override
    public void toBytes(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos).func_179249_a((Enum)this.type).func_180714_a(VersionUtil.getRegistryName(this.enchantment).toString()).func_150786_a(this.data.writeToNBT(new NBTTagCompound())).writeInt(this.dim);
    }

    @Override
    public IMessage onReceive(IMessage message, MessageContext ctx) {
        TileBasic tile;
        World world = QuarryPlus.proxy.getPacketWorld(ctx.netHandler);
        MinecraftServer server = world.func_73046_m();
        if (world.field_73011_w.getDimension() == this.dim && server != null && (tile = (TileBasic)world.func_175625_s(this.pos)) != null) {
            server.func_152344_a(() -> {
                if (this.type == Type.Toggle) {
                    if (this.enchantment == Enchantments.field_185308_t) {
                        tile.fortuneInclude = !tile.fortuneInclude;
                    } else if (this.enchantment == Enchantments.field_185306_r) {
                        tile.silktouchInclude = !tile.silktouchInclude;
                    }
                } else if (this.type == Type.Remove) {
                    if (this.enchantment == Enchantments.field_185308_t) {
                        tile.fortuneList.remove(this.data);
                    } else if (this.enchantment == Enchantments.field_185306_r) {
                        tile.silktouchList.remove(this.data);
                    }
                }
            });
        }
        return null;
    }

    public static enum Type {
        Toggle,
        Remove;

    }
}

