/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.tile;

import cofh.api.tileentity.IInventoryConnection;
import com.yogpc.qp.Config;
import com.yogpc.qp.PowerManager;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.compat.InvUtils;
import com.yogpc.qp.tile.APacketTile;
import com.yogpc.qp.tile.APowerTile;
import com.yogpc.qp.tile.HasInv;
import com.yogpc.qp.tile.IAttachable;
import com.yogpc.qp.tile.IAttachment;
import com.yogpc.qp.tile.IEnchantableTile;
import com.yogpc.qp.tile.IModule;
import com.yogpc.qp.tile.QuarryBlackList;
import com.yogpc.qp.tile.QuarryFakePlayer;
import com.yogpc.qp.tile.TilePump;
import com.yogpc.qp.utils.BlockData;
import com.yogpc.qp.utils.NBTBuilder;
import com.yogpc.qp.utils.NoDuplicateList;
import com.yogpc.qp.utils.ReflectionHelper;
import com.yogpc.qp.version.VersionUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jp.t2v.lab.syntax.MapStreamSyntax;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

@Optional.Interface(iface="cofh.api.tileentity.IInventoryConnection", modid="cofhcore")
public abstract class TileBasic
extends APowerTile
implements IEnchantableTile,
HasInv,
IInventoryConnection,
IAttachable {
    private static final Set<IAttachment.Attachments<?>> VALID_ATTACHMENTS = IAttachment.Attachments.ALL;
    protected final Map<IAttachment.Attachments<?>, EnumFacing> facingMap = new HashMap();
    public NoDuplicateList<BlockData> fortuneList = NoDuplicateList.create(ArrayList::new);
    public NoDuplicateList<BlockData> silktouchList = NoDuplicateList.create(ArrayList::new);
    public boolean fortuneInclude;
    public boolean silktouchInclude;
    protected byte unbreaking;
    protected byte fortune;
    protected boolean silktouch;
    protected byte efficiency;
    protected final LinkedList<ItemStack> cacheItems = new LinkedList();
    protected final IItemHandler handler = this.createHandler();
    protected Map<Integer, Integer> ench = new HashMap<Integer, Integer>();
    public List<IModule> modules = Collections.emptyList();
    public int yLevel = 1;
    public static final Method createStackedBlock = ReflectionHelper.getMethod(Block.class, new String[]{"func_180643_i", "getSilkTouchDrop"}, new Class[][]{{IBlockState.class}});

    public abstract void G_renew_powerConfigure();

    protected abstract void G_destroy();

    @Override
    public final void onChunkUnload() {
        this.G_destroy();
        super.onChunkUnload();
    }

    protected void S_pollItems() {
        ItemStack is;
        while (null != (is = this.cacheItems.poll())) {
            ItemStack stack = InvUtils.injectToNearTile(this.func_145831_w(), this.func_174877_v(), is);
            if (VersionUtil.getCount(stack) <= 0) continue;
            this.cacheItems.add(stack);
            break;
        }
    }

    protected boolean S_breakBlock(int x, int y, int z, IBlockState replace) {
        ArrayList<ItemStack> dropped = new ArrayList<ItemStack>(2);
        Chunk loadedChunk = this.func_145831_w().func_72863_F().func_186026_b(x >> 4, z >> 4);
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState blockState = loadedChunk == null ? this.func_145831_w().func_180495_p(pos) : loadedChunk.func_186032_a(x & 0xF, y, z & 0xF);
        if (QuarryBlackList.contains(blockState, this.func_145831_w(), pos)) {
            return true;
        }
        this.modules.forEach(iModule -> iModule.invoke(new IModule.BeforeBreak(this.field_145850_b, pos)));
        IBlockState maybeUpdated = this.field_145850_b.func_180495_p(pos);
        QuarryFakePlayer fakePlayer = QuarryFakePlayer.get((WorldServer)this.func_145831_w(), pos);
        fakePlayer.func_184611_a(EnumHand.MAIN_HAND, this.getEnchantedPickaxe());
        if (!maybeUpdated.func_177230_c().isAir(maybeUpdated, (IBlockAccess)this.field_145850_b, pos)) {
            int enchantmentLevel = maybeUpdated.func_177230_c().canSilkHarvest(this.field_145850_b, pos, maybeUpdated, (EntityPlayer)fakePlayer) && this.silktouch && this.silktouchList.contains(new BlockData(maybeUpdated.func_177230_c(), maybeUpdated)) == this.silktouchInclude ? -1 : this.fortune;
            if (!PowerManager.useEnergyBreak(this, maybeUpdated.func_185887_b(this.func_145831_w(), pos), enchantmentLevel, this.unbreaking, this.facingMap.containsKey(IAttachment.Attachments.REPLACER), blockState)) {
                return false;
            }
        }
        BI bi = this.S_addDroppedItems(dropped, blockState, pos, fakePlayer);
        this.cacheItems.addAll(dropped);
        this.modules.forEach(iModule -> iModule.invoke(new IModule.AfterBreak(this.field_145850_b, pos, maybeUpdated, this.field_145850_b.func_82737_E(), bi.i)));
        if (this.facingMap.containsKey(IAttachment.Attachments.FLUID_PUMP) && TilePump.isLiquid(blockState)) {
            TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(this.facingMap.get(IAttachment.Attachments.FLUID_PUMP)));
            if (!(te instanceof TilePump)) {
                this.facingMap.remove(IAttachment.Attachments.FLUID_PUMP);
                this.G_renew_powerConfigure();
                return true;
            }
            boolean b2 = ((TilePump)te).S_removeLiquids(this, x, y, z);
            if (blockState.func_185904_a().func_76224_d()) {
                return b2;
            }
        }
        this.func_145831_w().func_175718_b(2001, pos, Block.func_176210_f((IBlockState)blockState));
        this.func_145831_w().func_180501_a(pos, replace, 3);
        return true;
    }

    @Override
    public boolean connectAttachment(EnumFacing facing, IAttachment.Attachments<? extends APacketTile> attachments, boolean simulate) {
        TileEntity entity;
        if (this.facingMap.containsKey(attachments) && attachments.test(entity = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(this.facingMap.get(attachments)))) && this.facingMap.get(attachments) != facing) {
            return false;
        }
        if (!simulate) {
            this.facingMap.put(attachments, facing);
            this.G_renew_powerConfigure();
            this.modules = this.facingMap.entrySet().stream().map(MapStreamSyntax.values(arg_0 -> ((BlockPos)this.field_174879_c).func_177972_a(arg_0))).map(MapStreamSyntax.values(arg_0 -> ((World)this.field_145850_b).func_175625_s(arg_0))).map(MapStreamSyntax.toAny(IAttachment.Attachments::module)).flatMap(iModule -> iModule.map(Stream::of).orElse(Stream.empty())).collect(Collectors.toList());
        }
        return true;
    }

    @Override
    public boolean isValidAttachment(IAttachment.Attachments<? extends APacketTile> attachments) {
        return VALID_ATTACHMENTS.contains(attachments);
    }

    public void setYLevel(int yLevel) {
        this.yLevel = yLevel;
        if (yLevel <= 0 && Config.content().debug()) {
            QuarryPlus.LOGGER.warn("Quarry yLevel is set to " + yLevel + ".");
        }
    }

    private BI S_addDroppedItems(Collection<ItemStack> collection, IBlockState state, BlockPos pos, QuarryFakePlayer fakePlayer) {
        int i;
        Block block = state.func_177230_c();
        int xp = 0;
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(this.field_145850_b, pos, state, (EntityPlayer)fakePlayer);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (!event.isCanceled()) {
            HashSet<ItemStack> rawItems;
            if (block.canSilkHarvest(this.func_145831_w(), pos, state, (EntityPlayer)fakePlayer) && this.silktouch && this.silktouchList.contains(new BlockData(block, state)) == this.silktouchInclude) {
                ArrayList<ItemStack> list = new ArrayList<ItemStack>(1);
                list.add((ItemStack)ReflectionHelper.invoke(createStackedBlock, block, state));
                rawItems = new HashSet(list);
                ForgeEventFactory.fireBlockHarvesting(list, (World)this.field_145850_b, (BlockPos)pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)fakePlayer);
                collection.addAll(list);
                i = -1;
            } else {
                boolean b2 = this.fortuneList.contains(new BlockData(block, state)) == this.fortuneInclude;
                int fortuneLevel = b2 ? this.fortune : 0;
                NonNullList list = NonNullList.func_191196_a();
                TileBasic.getDrops(this.func_145831_w(), pos, state, block, fortuneLevel, (NonNullList<ItemStack>)list);
                rawItems = new HashSet<ItemStack>((Collection<ItemStack>)list);
                ForgeEventFactory.fireBlockHarvesting((List)list, (World)this.field_145850_b, (BlockPos)pos, (IBlockState)state, (int)fortuneLevel, (float)1.0f, (boolean)false, (EntityPlayer)fakePlayer);
                collection.addAll((Collection<ItemStack>)list);
                i = fortuneLevel;
            }
            if (this.facingMap.containsKey(IAttachment.Attachments.EXP_PUMP)) {
                xp += event.getExpToDrop();
                if (InvUtils.hasSmelting(fakePlayer.func_184614_ca())) {
                    xp += TileBasic.getSmeltingXp(collection, rawItems);
                }
            }
        } else {
            i = -2;
        }
        fakePlayer.func_184611_a(EnumHand.MAIN_HAND, VersionUtil.empty());
        return new BI((byte)i, xp, this.facingMap.containsKey(IAttachment.Attachments.REPLACER));
    }

    public static void getDrops(World world, BlockPos pos, IBlockState state, Block block, int fortuneLevel, NonNullList<ItemStack> list) {
        if ("thaumcraft".equals(block.getRegistryName().func_110624_b())) {
            list.addAll((Collection)block.getDrops((IBlockAccess)world, pos, state, fortuneLevel));
        } else {
            block.getDrops(list, (IBlockAccess)world, pos, state, fortuneLevel);
        }
    }

    public static int getSmeltingXp(Collection<ItemStack> stacks, Collection<ItemStack> raw) {
        return stacks.stream().filter(MapStreamSyntax.not(raw::contains)).mapToInt(stack -> TileBasic.floorFloat(FurnaceRecipes.func_77602_a().func_151398_b(stack) * (float)VersionUtil.getCount(stack))).sum();
    }

    static int floorFloat(float value) {
        int i = MathHelper.func_76141_d((float)value);
        return i + (Math.random() < (double)(value - (float)i) ? 1 : 0);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.silktouch = nbt.func_74767_n("silktouch");
        this.fortune = nbt.func_74771_c("fortune");
        this.efficiency = nbt.func_74771_c("efficiency");
        this.unbreaking = nbt.func_74771_c("unbreaking");
        this.fortuneInclude = nbt.func_74767_n("fortuneInclude");
        this.silktouchInclude = nbt.func_74767_n("silktouchInclude");
        this.yLevel = Math.max(nbt.func_74762_e("yLevel"), 1);
        TileBasic.readLongCollection(nbt.func_150295_c("fortuneList", 10), this.fortuneList);
        TileBasic.readLongCollection(nbt.func_150295_c("silktouchList", 10), this.silktouchList);
        this.ench = NBTBuilder.fromList(nbt.func_150295_c("enchList", 10), n -> n.func_74762_e("id"), n -> n.func_74762_e("value"), s -> Enchantment.func_185262_c((int)s) != null, MapStreamSyntax.always_true());
    }

    private static void readLongCollection(NBTTagList list, Collection<BlockData> target) {
        target.clear();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound c = list.func_150305_b(i);
            target.add(new BlockData(c.func_74779_i(BlockData.Name_NBT()), c.func_74762_e(BlockData.Meta_NBT())));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74757_a("silktouch", this.silktouch);
        nbt.func_74774_a("fortune", this.fortune);
        nbt.func_74774_a("efficiency", this.efficiency);
        nbt.func_74774_a("unbreaking", this.unbreaking);
        nbt.func_74757_a("fortuneInclude", this.fortuneInclude);
        nbt.func_74757_a("silktouchInclude", this.silktouchInclude);
        nbt.func_74782_a("fortuneList", (NBTBase)TileBasic.writeLongCollection(this.fortuneList));
        nbt.func_74782_a("silktouchList", (NBTBase)TileBasic.writeLongCollection(this.silktouchList));
        nbt.func_74768_a("yLevel", this.yLevel);
        Function<Integer, Short> function = Integer::shortValue;
        nbt.func_74782_a("enchList", (NBTBase)NBTBuilder.fromMap(this.ench, "id", "value", function.andThen(NBTTagShort::new), function.andThen(NBTTagShort::new)));
        return super.func_189515_b(nbt);
    }

    private static NBTTagList writeLongCollection(Collection<BlockData> target) {
        return target.stream().map(l -> l.toNBT().func_74775_l(BlockData.BlockData_NBT())).collect(VersionUtil.toNBTList());
    }

    @Override
    public Map<Integer, Integer> getEnchantments() {
        HashMap<Integer, Integer> ret = new HashMap<Integer, Integer>(this.ench);
        if (this.efficiency > 0) {
            ret.put(EfficiencyID, Integer.valueOf(this.efficiency));
        }
        if (this.fortune > 0) {
            ret.put(FortuneID, Integer.valueOf(this.fortune));
        }
        if (this.unbreaking > 0) {
            ret.put(UnbreakingID, Integer.valueOf(this.unbreaking));
        }
        if (this.silktouch) {
            ret.put(SilktouchID, 1);
        }
        return ret;
    }

    @Override
    public void setEnchantment(short id, short val) {
        if (id == EfficiencyID) {
            this.efficiency = (byte)val;
        } else if (id == FortuneID) {
            this.fortune = (byte)val;
        } else if (id == UnbreakingID) {
            this.unbreaking = (byte)val;
        } else if (id == SilktouchID) {
            boolean bl = this.silktouch = val > 0;
        }
        if (val > 0) {
            this.ench.put(Integer.valueOf(id), Integer.valueOf(val));
        }
    }

    @Override
    public int func_70302_i_() {
        return Math.max(1, this.cacheItems.size());
    }

    @Override
    @Nonnull
    public ItemStack func_70301_a(int i) {
        return i < 0 || i >= this.cacheItems.size() ? VersionUtil.empty() : this.cacheItems.get(i);
    }

    @Override
    @Nonnull
    public ItemStack func_70298_a(int index, int count) {
        if (index < 0 || index >= this.cacheItems.size()) {
            return VersionUtil.empty();
        }
        ItemStack from2 = this.cacheItems.get(index);
        ItemStack res = new ItemStack(from2.func_77973_b(), Math.min(count, VersionUtil.getCount(from2)), from2.func_77952_i());
        Optional.ofNullable(from2.func_77978_p()).map(NBTTagCompound::func_74737_b).ifPresent(arg_0 -> ((ItemStack)res).func_77982_d(arg_0));
        VersionUtil.shrink(from2, VersionUtil.getCount(res));
        if (VersionUtil.isEmpty(from2)) {
            this.cacheItems.remove(index);
        }
        return res;
    }

    @Override
    @Nonnull
    public ItemStack func_70304_b(int index) {
        return index < 0 || index >= this.cacheItems.size() ? VersionUtil.empty() : this.cacheItems.remove(index);
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        if (VersionUtil.nonEmpty(stack)) {
            QuarryPlus.LOGGER.warn("QuarryPlus WARN: call setInventorySlotContents with non null ItemStack.");
        }
        this.func_70304_b(index);
    }

    public String func_70005_c_() {
        return "container.yog.basic";
    }

    @Override
    public boolean func_70300_a(EntityPlayer player) {
        return false;
    }

    @Override
    public boolean func_191420_l() {
        return this.cacheItems.isEmpty();
    }

    @Override
    public void func_174888_l() {
        this.cacheItems.clear();
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.handler);
        }
        return super.getCapability(capability, facing);
    }

    @Optional.Method(modid="cofhcore")
    public final IInventoryConnection.ConnectionType canConnectInventory(EnumFacing from2) {
        return IInventoryConnection.ConnectionType.FORCE;
    }

    private static class BI {
        final byte b;
        final int i;
        final boolean b1;

        private BI(byte b2, int i, boolean b1) {
            this.b = b2;
            this.i = i;
            this.b1 = b1;
        }
    }
}

