/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.tile;

import buildcraft.api.tiles.ITileAreaProvider;
import buildcraft.api.tiles.TilesAPI;
import buildcraft.lib.misc.PositionUtil;
import com.yogpc.qp.Config;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.QuarryPlusI;
import com.yogpc.qp.packet.PacketHandler;
import com.yogpc.qp.packet.marker.LinkReply;
import com.yogpc.qp.packet.marker.LinkUpdate;
import com.yogpc.qp.render.Box;
import com.yogpc.qp.tile.APacketTile;
import com.yogpc.qp.tile.IChunkLoadTile;
import com.yogpc.qp.tile.IDebugSender;
import com.yogpc.qp.tile.IMarker;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import jp.t2v.lab.syntax.MapStreamSyntax;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import scala.Symbol;

@Optional.Interface(iface="buildcraft.api.tiles.ITileAreaProvider", modid="buildcraftlib")
public class TileMarker
extends APacketTile
implements ITileAreaProvider,
IChunkLoadTile,
IDebugSender,
IMarker {
    private static final int MAX_SIZE = 256;
    public static final Symbol SYMBOL = Symbol.apply((String)"MarkerPlus");
    private final boolean bcLoaded = Loader.isModLoaded((String)"buildcraftlib");
    @Nullable
    public Link link;
    @Nullable
    public Laser laser;
    private ForgeChunkManager.Ticket chunkTicket;

    @Override
    protected Symbol getSymbol() {
        return SYMBOL;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        if (this.laser != null) {
            compound.func_74772_a("laser", this.laser.getLaserPos().func_177986_g());
        }
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("laser") && this.field_145850_b != null) {
            this.laser = new Laser(BlockPos.func_177969_a((long)compound.func_74763_f("laser")), this.link, this.field_145850_b.field_72995_K);
        }
    }

    @Override
    public boolean hasLink() {
        return this.link != null && this.link.xMin != this.link.xMax && this.link.zMin != this.link.zMax;
    }

    @Override
    public BlockPos min() {
        return this.link == null ? this.func_174877_v() : this.link.minPos();
    }

    @Override
    public BlockPos max() {
        return this.link == null ? this.func_174877_v() : this.link.maxPos();
    }

    public void removeFromWorld() {
        if (this.link == null) {
            this.func_145838_q().func_176226_b(this.func_145831_w(), this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), 0);
            this.func_145831_w().func_175698_g(this.func_174877_v());
            return;
        }
        List<ItemStack> al = this.link.removeAndGetItem(this.func_145831_w());
        for (ItemStack is : al) {
            InventoryHelper.func_180173_a((World)this.func_145831_w(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (ItemStack)is);
        }
    }

    @Override
    public List<ItemStack> removeFromWorldWithItem() {
        if (this.link != null) {
            return this.link.removeAndGetItem(this.func_145831_w());
        }
        NonNullList ret = NonNullList.func_191196_a();
        QuarryPlusI.blockMarker().getDrops(ret, (IBlockAccess)this.func_145831_w(), this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), 0);
        this.func_145831_w().func_175698_g(this.func_174877_v());
        return ret;
    }

    private static Optional<Link> S_renewConnection(World world, BlockPos basePos, boolean first) {
        TileMarker xMarker = IntStream.range(1, 256).flatMap(i -> IntStream.of(i, -i)).mapToObj(i -> basePos.func_177982_a(i, 0, 0)).map(arg_0 -> ((World)world).func_175625_s(arg_0)).flatMap(MapStreamSyntax.streamCast(TileMarker.class)).findFirst().orElse(null);
        TileMarker yMarker = IntStream.range(1, 256).flatMap(i -> IntStream.of(i, -i)).mapToObj(i -> basePos.func_177982_a(0, i, 0)).filter(arg_0 -> ((World)world).func_175701_a(arg_0)).map(arg_0 -> ((World)world).func_175625_s(arg_0)).flatMap(MapStreamSyntax.streamCast(TileMarker.class)).findFirst().orElse(null);
        TileMarker zMarker = IntStream.range(1, 256).flatMap(i -> IntStream.of(i, -i)).mapToObj(i -> basePos.func_177982_a(0, 0, i)).map(arg_0 -> ((World)world).func_175625_s(arg_0)).flatMap(MapStreamSyntax.streamCast(TileMarker.class)).findFirst().orElse(null);
        if (xMarker != null && zMarker != null) {
            if (yMarker != null) {
                int yMin = Math.min(xMarker.func_174877_v().func_177956_o(), yMarker.func_174877_v().func_177956_o());
                int yMax = Math.max(xMarker.func_174877_v().func_177956_o(), yMarker.func_174877_v().func_177956_o());
                BlockPos xPos = new BlockPos(xMarker.func_174877_v().func_177958_n(), yMin, xMarker.func_174877_v().func_177952_p());
                BlockPos zPos = new BlockPos(zMarker.func_174877_v().func_177958_n(), yMax, zMarker.func_174877_v().func_177952_p());
                return Optional.of(new Link(xPos, zPos, true));
            }
            return Optional.of(new Link(xMarker.func_174877_v(), zMarker.func_174877_v(), true));
        }
        if (first) {
            Optional<Link> x = Optional.ofNullable(xMarker).flatMap(m -> TileMarker.S_renewConnection(world, m.func_174877_v(), false));
            if (x.isPresent()) {
                return x;
            }
            return Optional.ofNullable(zMarker).flatMap(m -> TileMarker.S_renewConnection(world, m.func_174877_v(), false));
        }
        return Optional.empty();
    }

    public void G_updateSignal() {
        if (this.laser != null) {
            this.laser = null;
        }
        if (!this.func_145831_w().field_72995_K && !Config.content().disableMapJ().get(SYMBOL).booleanValue()) {
            if (this.func_145831_w().func_175640_z(this.func_174877_v()) && (this.link == null || this.link.xMin == this.link.xMax || this.link.yMin == this.link.yMax || this.link.zMin == this.link.zMax)) {
                this.laser = new Laser(this.func_174877_v(), this.link, false);
                PacketHandler.sendToAround(LinkUpdate.create(this, true), this.func_145831_w(), this.func_174877_v());
            } else {
                PacketHandler.sendToAround(LinkUpdate.create(this, false), this.func_145831_w(), this.func_174877_v());
            }
        }
    }

    public void S_tryConnection() {
        if (this.link != null) {
            this.link.removeLink(this.func_145831_w());
        }
        TileMarker.S_renewConnection(this.func_145831_w(), this.func_174877_v(), true).ifPresent(this::setLink);
    }

    void setLink(Link parentLink) {
        this.link = parentLink;
        Link childLink = this.link.noRender();
        this.link.edgePoses().filter(Predicate.isEqual(this.func_174877_v()).negate()).map(arg_0 -> ((World)this.func_145831_w()).func_175625_s(arg_0)).flatMap(MapStreamSyntax.streamCast(TileMarker.class)).forEach(marker -> {
            marker.link = childLink;
        });
        PacketHandler.sendToAround(LinkReply.create(this.func_174877_v(), parentLink), this.func_145831_w(), this.func_174877_v());
        this.G_updateSignal();
    }

    void G_destroy() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.link != null) {
            this.link.removeLink(this.func_145831_w());
        }
        if (this.laser != null) {
            this.laser = null;
        }
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.chunkTicket);
    }

    @Override
    public void requestTicket() {
        if (this.chunkTicket != null) {
            return;
        }
        this.chunkTicket = ForgeChunkManager.requestTicket((Object)QuarryPlus.INSTANCE, (World)this.func_145831_w(), (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        this.setTileData(this.chunkTicket, this.func_174877_v());
    }

    @Override
    public void forceChunkLoading(ForgeChunkManager.Ticket ticket) {
        if (this.chunkTicket == null) {
            this.chunkTicket = ticket;
        }
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)new ChunkPos(this.func_174877_v()));
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        if (this.laser != null || this.link != null) {
            return 262144.0;
        }
        return super.func_145833_n();
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (this.bcLoaded && capability == TilesAPI.CAP_TILE_AREA_PROVIDER) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.bcLoaded && capability == TilesAPI.CAP_TILE_AREA_PROVIDER) {
            return (T)TilesAPI.CAP_TILE_AREA_PROVIDER.cast((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_145829_t() {
        super.func_145829_t();
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.func_145831_w().func_180495_p(this.func_174877_v()).func_177230_c() != QuarryPlusI.blockMarker()) {
            this.G_destroy();
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
    }

    @Optional.Method(modid="buildcraftlib")
    public boolean isValidFromLocation(BlockPos pos) {
        if (this.link != null) {
            boolean zFlag;
            boolean xFlag = this.link.xMin <= pos.func_177958_n() && this.link.xMax <= pos.func_177958_n();
            boolean yFlag = this.link.yMin <= pos.func_177956_o() && this.link.yMax <= pos.func_177956_o();
            boolean bl = zFlag = this.link.zMin <= pos.func_177952_p() && this.link.zMax <= pos.func_177952_p();
            if (xFlag && yFlag && zFlag) {
                return false;
            }
            Predicate<BlockPos> predicate = p -> PositionUtil.isNextTo((BlockPos)p, (BlockPos)pos);
            return PositionUtil.getCorners((BlockPos)this.min(), (BlockPos)this.max()).stream().anyMatch(predicate);
        }
        return false;
    }

    @Override
    public String getDebugName() {
        return "tile.markerplus.name";
    }

    @Override
    public List<? extends ITextComponent> getDebugMessages() {
        return Arrays.asList(new TextComponentString("Link : " + this.link), new TextComponentString("Laser : " + this.laser), new TextComponentString("0x" + Integer.toHexString(this.hashCode())));
    }

    public static class Link {
        public final int xMax;
        public final int xMin;
        public final int yMax;
        public final int yMin;
        public final int zMax;
        public final int zMin;
        @Nullable
        public Box[] boxes;
        public final boolean shouldBeRendered;

        public Link(int xMax, int xMin, int yMax, int yMin, int zMax, int zMin, boolean shouldBeRendered) {
            this.xMax = xMax;
            this.xMin = xMin;
            this.yMax = yMax;
            this.yMin = yMin;
            this.zMax = zMax;
            this.zMin = zMin;
            this.shouldBeRendered = shouldBeRendered;
        }

        public Link(BlockPos pos1, BlockPos pos2, boolean shouldBeRendered) {
            this.xMin = Math.min(pos1.func_177958_n(), pos2.func_177958_n());
            this.yMin = Math.min(pos1.func_177956_o(), pos2.func_177956_o());
            this.zMin = Math.min(pos1.func_177952_p(), pos2.func_177952_p());
            this.xMax = Math.max(pos1.func_177958_n(), pos2.func_177958_n());
            this.yMax = Math.max(pos1.func_177956_o(), pos2.func_177956_o());
            this.zMax = Math.max(pos1.func_177952_p(), pos2.func_177952_p());
            this.shouldBeRendered = shouldBeRendered;
        }

        public Link(NBTTagCompound compound) {
            BlockPos max = BlockPos.func_177969_a((long)compound.func_74763_f("maxPos"));
            BlockPos min = BlockPos.func_177969_a((long)compound.func_74763_f("minPos"));
            this.shouldBeRendered = compound.func_74767_n("shouldBeRendered");
            this.xMax = max.func_177958_n();
            this.yMax = max.func_177956_o();
            this.zMax = max.func_177952_p();
            this.xMin = min.func_177958_n();
            this.yMin = min.func_177956_o();
            this.zMin = min.func_177952_p();
        }

        public void makeLaser(boolean isRemote) {
            if (!isRemote || !this.shouldBeRendered) {
                return;
            }
            byte flag = 0;
            double a2 = 0.5;
            double b2 = 0.625;
            double c = 0.375;
            AxisAlignedBB[] lineBoxes = new AxisAlignedBB[12];
            if (this.xMin != this.xMax) {
                flag = (byte)(flag | 1);
            }
            if (this.yMin != this.yMax) {
                flag = (byte)(flag | 2);
            }
            if (this.zMin != this.zMax) {
                flag = (byte)(flag | 4);
            }
            if ((flag & 1) == 1) {
                lineBoxes[0] = new AxisAlignedBB((double)this.xMin + 0.625, (double)this.yMin + 0.5, (double)this.zMin + 0.5, (double)this.xMax + 0.375, (double)this.yMin + 0.5, (double)this.zMin + 0.5);
            }
            if ((flag & 2) == 2) {
                lineBoxes[4] = new AxisAlignedBB((double)this.xMin + 0.5, (double)this.yMin + 0.625, (double)this.zMin + 0.5, (double)this.xMin + 0.5, (double)this.yMax + 0.375, (double)this.zMin + 0.5);
            }
            if ((flag & 4) == 4) {
                lineBoxes[8] = new AxisAlignedBB((double)this.xMin + 0.5, (double)this.yMin + 0.5, (double)this.zMin + 0.625, (double)this.xMin + 0.5, (double)this.yMin + 0.5, (double)this.zMax + 0.375);
            }
            if ((flag & 3) == 3) {
                lineBoxes[2] = new AxisAlignedBB((double)this.xMin + 0.625, (double)this.yMax + 0.5, (double)this.zMin + 0.5, (double)this.xMax + 0.375, (double)this.yMax + 0.5, (double)this.zMin + 0.5);
                lineBoxes[6] = new AxisAlignedBB((double)this.xMax + 0.5, (double)this.yMin + 0.625, (double)this.zMin + 0.5, (double)this.xMax + 0.5, (double)this.yMax + 0.375, (double)this.zMin + 0.5);
            }
            if ((flag & 5) == 5) {
                lineBoxes[1] = new AxisAlignedBB((double)this.xMin + 0.625, (double)this.yMin + 0.5, (double)this.zMax + 0.5, (double)this.xMax + 0.375, (double)this.yMin + 0.5, (double)this.zMax + 0.5);
                lineBoxes[9] = new AxisAlignedBB((double)this.xMax + 0.5, (double)this.yMin + 0.5, (double)this.zMin + 0.625, (double)this.xMax + 0.5, (double)this.yMin + 0.5, (double)this.zMax + 0.375);
            }
            if ((flag & 6) == 6) {
                lineBoxes[5] = new AxisAlignedBB((double)this.xMin + 0.5, (double)this.yMin + 0.625, (double)this.zMax + 0.5, (double)this.xMin + 0.5, (double)this.yMax + 0.375, (double)this.zMax + 0.5);
                lineBoxes[10] = new AxisAlignedBB((double)this.xMin + 0.5, (double)this.yMax + 0.5, (double)this.zMin + 0.625, (double)this.xMin + 0.5, (double)this.yMax + 0.5, (double)this.zMax + 0.375);
            }
            if ((flag & 7) == 7) {
                lineBoxes[3] = new AxisAlignedBB((double)this.xMin + 0.625, (double)this.yMax + 0.5, (double)this.zMax + 0.5, (double)this.xMax + 0.375, (double)this.yMax + 0.5, (double)this.zMax + 0.5);
                lineBoxes[7] = new AxisAlignedBB((double)this.xMax + 0.5, (double)this.yMin + 0.625, (double)this.zMax + 0.5, (double)this.xMax + 0.5, (double)this.yMax + 0.375, (double)this.zMax + 0.5);
                lineBoxes[11] = new AxisAlignedBB((double)this.xMax + 0.5, (double)this.yMax + 0.5, (double)this.zMin + 0.625, (double)this.xMax + 0.5, (double)this.yMax + 0.5, (double)this.zMax + 0.375);
            }
            this.boxes = (Box[])Arrays.stream(lineBoxes).filter(APacketTile.nonNull).map(range -> Box.apply(range, 0.125, 0.125, 0.125, false, false)).toArray(Box[]::new);
        }

        public BlockPos minPos() {
            return new BlockPos(this.xMin, this.yMin, this.zMin);
        }

        public BlockPos maxPos() {
            return new BlockPos(this.xMax, this.yMax, this.zMax);
        }

        Stream<BlockPos> edgePoses() {
            return Stream.of(this.minPos(), new BlockPos(this.xMin, this.yMin, this.zMax), new BlockPos(this.xMin, this.yMax, this.zMin), new BlockPos(this.xMin, this.yMax, this.zMax), new BlockPos(this.xMax, this.yMin, this.zMin), new BlockPos(this.xMax, this.yMin, this.zMax), new BlockPos(this.xMax, this.yMax, this.zMin), this.maxPos());
        }

        Link noRender() {
            return new Link(this.xMax, this.xMin, this.yMax, this.yMin, this.zMax, this.zMin, false);
        }

        public void removeLink(World world) {
            this.edgePoses().map(arg_0 -> ((World)world).func_175625_s(arg_0)).flatMap(MapStreamSyntax.streamCast(TileMarker.class)).forEach(marker -> {
                marker.link = null;
                PacketHandler.sendToAround(LinkReply.create(marker.func_174877_v(), null), marker.func_145831_w(), marker.func_174877_v());
            });
        }

        List<ItemStack> removeAndGetItem(World world) {
            List<TileMarker> markers = this.edgePoses().distinct().map(arg_0 -> ((World)world).func_175625_s(arg_0)).flatMap(MapStreamSyntax.streamCast(TileMarker.class)).collect(Collectors.toList());
            NonNullList stacks = NonNullList.func_191196_a();
            markers.forEach(m -> m.func_145838_q().getDrops(stacks, (IBlockAccess)world, m.func_174877_v(), world.func_180495_p(m.func_174877_v()), 0));
            markers.stream().map(TileEntity::func_174877_v).forEach(arg_0 -> ((World)world).func_175698_g(arg_0));
            return stacks;
        }

        public NBTTagCompound toNbt() {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74772_a("maxPos", this.maxPos().func_177986_g());
            compound.func_74772_a("minPos", this.minPos().func_177986_g());
            compound.func_74757_a("shouldBeRendered", this.shouldBeRendered);
            return compound;
        }

        public String toString() {
            return String.format("Link{(%d, %d, %d) -> (%d, %d, %d), shouldBeRendered=%b}", this.xMin, this.yMin, this.zMin, this.xMax, this.yMax, this.zMax, this.shouldBeRendered);
        }
    }

    public static class Laser {
        final int x;
        final int y;
        final int z;
        public final AxisAlignedBB[] lineBoxes = new AxisAlignedBB[6];
        @Nullable
        public final Box[] boxes;

        public Laser(BlockPos pos, Link link, boolean isRemote) {
            this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), link, isRemote);
        }

        private Laser(int px, int py, int pz, @Nullable Link l, boolean isRemote) {
            this.x = px;
            this.y = py;
            this.z = pz;
            double b2 = 0.625;
            double c = 0.375;
            if (l == null || l.xMin == l.xMax) {
                this.lineBoxes[0] = new AxisAlignedBB((double)px + b2 - 256.0, (double)py + 0.5, (double)pz + 0.5, (double)px + c, (double)py + 0.5, (double)pz + 0.5);
                this.lineBoxes[3] = new AxisAlignedBB((double)px + b2, (double)py + 0.5, (double)pz + 0.5, (double)px + c + 256.0, (double)py + 0.5, (double)pz + 0.5);
            }
            if (l == null || l.yMin == l.yMax) {
                this.lineBoxes[1] = new AxisAlignedBB((double)px + 0.5, 0.0, (double)pz + 0.5, (double)px + 0.5, (double)py - 0.1, (double)pz + 0.5);
                this.lineBoxes[4] = new AxisAlignedBB((double)px + 0.5, (double)py + b2, (double)pz + 0.5, (double)px + 0.5, 255.0, (double)pz + 0.5);
            }
            if (l == null || l.zMin == l.zMax) {
                this.lineBoxes[2] = new AxisAlignedBB((double)px + 0.5, (double)py + 0.5, (double)pz + b2 - 256.0, (double)px + 0.5, (double)py + 0.5, (double)pz + c);
                this.lineBoxes[5] = new AxisAlignedBB((double)px + 0.5, (double)py + 0.5, (double)pz + b2, (double)px + 0.5, (double)py + 0.5, (double)pz + c + 256.0);
            }
            this.boxes = isRemote && !Config.content().disableRendering() ? (Box[])Arrays.stream(this.lineBoxes).filter(APacketTile.nonNull).map(range -> Box.apply(range, 0.125, 0.125, 0.125, false, false)).toArray(Box[]::new) : null;
        }

        public String toString() {
            long i = Stream.of(this.lineBoxes).filter(APacketTile.nonNull).count();
            return this.x + " " + this.y + " " + this.z + " Lasers : " + i;
        }

        BlockPos getLaserPos() {
            return new BlockPos(this.x, this.y, this.z);
        }
    }

    public static class BlockIndex {
        final World w;
        final int x;
        final int y;
        final int z;

        public BlockIndex(World pw, int px, int py, int pz) {
            this.w = pw;
            this.x = px;
            this.y = py;
            this.z = pz;
        }
    }
}

