/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.utils;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class NoDuplicateList<V extends Comparable<V>>
implements List<V>,
Set<V> {
    private final Set<V> set = new HashSet<V>();
    private final List<V> list;

    public static <V extends Comparable<V>> NoDuplicateList<V> create(Supplier<List<V>> listSupplier) {
        return new NoDuplicateList<V>(listSupplier);
    }

    public NoDuplicateList(Supplier<List<V>> listSupplier) {
        this.list = listSupplier.get();
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.set.contains(o);
    }

    @Override
    @Nonnull
    public Iterator<V> iterator() {
        return this.listIterator();
    }

    @Override
    public void forEach(Consumer<? super V> action2) {
        this.list.forEach(action2);
    }

    @Override
    @Nonnull
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    @Nonnull
    public <T> T[] toArray(@Nonnull T[] a2) {
        return this.list.toArray(a2);
    }

    @Override
    public boolean add(V v) {
        if (this.set.add(v)) {
            this.list.add(v);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        if (this.set.remove(o)) {
            this.list.remove(o);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(@Nonnull Collection<?> c) {
        return this.set.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends V> c) {
        boolean b2 = false;
        for (Comparable v : c) {
            b2 |= this.add((V)v);
        }
        return b2;
    }

    @Override
    public boolean addAll(int index, Collection<? extends V> c) {
        boolean b2 = false;
        for (Comparable v : c) {
            if (!this.add(index, v, null)) continue;
            ++index;
            b2 = true;
        }
        return b2;
    }

    @Override
    public boolean removeAll(@Nonnull Collection<?> c) {
        this.set.removeAll(c);
        return this.list.removeAll(c);
    }

    @Override
    public boolean retainAll(@Nonnull Collection<?> c) {
        this.set.retainAll(c);
        return this.list.retainAll(c);
    }

    @Override
    public void clear() {
        this.set.clear();
        this.list.clear();
    }

    @Override
    public V get(int index) {
        return (V)((Comparable)this.list.get(index));
    }

    @Override
    public V set(int index, V element) {
        if (this.set.add(element)) {
            Comparable v = (Comparable)this.list.set(index, element);
            this.set.remove(v);
            return (V)v;
        }
        return null;
    }

    @Override
    public void add(int index, V element) {
        this.add(index, element, null);
    }

    private boolean add(int index, V element, Void dummy) {
        if (this.set.add(element)) {
            this.list.add(index, element);
            return true;
        }
        return false;
    }

    @Override
    public V remove(int index) {
        Comparable v = (Comparable)this.list.remove(index);
        this.set.remove(v);
        return (V)v;
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    @Nonnull
    public ListIterator<V> listIterator() {
        return this.list.listIterator();
    }

    @Override
    @Nonnull
    public ListIterator<V> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    @Nonnull
    public List<V> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    @Override
    public Spliterator<V> spliterator() {
        return this.list.spliterator();
    }
}

