/*
 * Decompiled with CFR 0.152.
 */
package com.wonderfulenchantments;

import com.mlib.items.ItemHelper;
import com.wonderfulenchantments.Instances;
import com.wonderfulenchantments.PacketHandler;
import com.wonderfulenchantments.RegistryHandlerClient;
import com.wonderfulenchantments.curses.WonderfulCurse;
import com.wonderfulenchantments.enchantments.WonderfulEnchantment;
import com.wonderfulenchantments.items.DyeableHorseArmorItemReplacement;
import com.wonderfulenchantments.items.HorseArmorItemReplacement;
import com.wonderfulenchantments.items.ShieldItemReplacement;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.HorseArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class RegistryHandler {
    public static final DeferredRegister<Enchantment> ENCHANTMENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENCHANTMENTS, (String)"wonderful_enchantments");
    public static final DeferredRegister<ParticleType<?>> PARTICLES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"wonderful_enchantments");
    public static final DeferredRegister<MobEffect> EFFECTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MOB_EFFECTS, (String)"wonderful_enchantments");
    public static final DeferredRegister<Item> ITEMS_TO_REPLACE = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"minecraft");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"wonderful_enchantments");
    public static final DeferredRegister<RecipeSerializer<?>> RECIPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"wonderful_enchantments");
    public static final EnchantmentCategory SHIELD = EnchantmentCategory.create((String)"shield", item -> item instanceof ShieldItem);
    public static final EnchantmentCategory HORSE_ARMOR = EnchantmentCategory.create((String)"horse_armor", item -> item instanceof HorseArmorItem);
    public static final EnchantmentCategory BOW_AND_CROSSBOW = EnchantmentCategory.create((String)"bow_and_crossbow", item -> item instanceof BowItem || item instanceof CrossbowItem);
    public static final EnchantmentCategory MELEE_WEAPON = EnchantmentCategory.create((String)"melee_weapon", item -> item instanceof SwordItem || item instanceof AxeItem || item instanceof TridentItem);
    public static final RegistryObject<SimpleParticleType> PHOENIX_PARTICLE = PARTICLES.register("phoenix_particle", () -> new SimpleParticleType(true));

    public static void init() {
        FMLJavaModLoadingContext modLoadingContext = FMLJavaModLoadingContext.get();
        IEventBus modEventBus = modLoadingContext.getModEventBus();
        new Instances();
        RegistryHandler.addEnchantments(modEventBus);
        RegistryHandler.replaceRestStandardMinecraftItems(modEventBus);
        RegistryHandler.addItems(modEventBus);
        PARTICLES.register(modEventBus);
        RegistryHandler.addEffects(modEventBus);
        RegistryHandler.addRecipes(modEventBus);
        RegistryHandler.addEnchantmentTypesToItemGroups();
        modEventBus.addListener(RegistryHandler::doClientSetup);
        modEventBus.addListener(PacketHandler::registerPacket);
    }

    private static void replaceRestStandardMinecraftItems(IEventBus modEventBus) {
        ITEMS_TO_REPLACE.register("shield", ShieldItemReplacement::new);
        ITEMS_TO_REPLACE.register("leather_horse_armor", () -> new DyeableHorseArmorItemReplacement(3, "leather"));
        ITEMS_TO_REPLACE.register("iron_horse_armor", () -> new HorseArmorItemReplacement(5, "iron"));
        ITEMS_TO_REPLACE.register("golden_horse_armor", () -> new HorseArmorItemReplacement(7, "gold"));
        ITEMS_TO_REPLACE.register("diamond_horse_armor", () -> new HorseArmorItemReplacement(11, "diamond"));
        ITEMS_TO_REPLACE.register(modEventBus);
    }

    private static void addItems(IEventBus modEventBus) {
        ITEMS.register("wonderful_book", () -> Instances.WONDERFUL_BOOK_ITEM);
        ITEMS.register(modEventBus);
    }

    private static void addEnchantments(IEventBus modEventBus) {
        for (WonderfulEnchantment enchantment : WonderfulEnchantment.ENCHANTMENT_LIST) {
            enchantment.register(ENCHANTMENTS);
        }
        for (WonderfulCurse curse : WonderfulCurse.CURSE_LIST) {
            curse.register(ENCHANTMENTS);
        }
        ENCHANTMENTS.register(modEventBus);
    }

    private static void addEffects(IEventBus modEventBus) {
        EFFECTS.register("mithridatism_protection", () -> Instances.MITHRIDATISM_PROTECTION);
        EFFECTS.register(modEventBus);
    }

    private static void addRecipes(IEventBus modEventBus) {
        RECIPES.register("energize_wonderful_book", (Supplier)Instances.WONDERFUL_BOOK_RECIPE.delegate);
        RECIPES.register(modEventBus);
    }

    private static void addEnchantmentTypesToItemGroups() {
        ItemHelper.addEnchantmentTypesToItemGroup((CreativeModeTab)CreativeModeTab.f_40757_, (EnchantmentCategory[])new EnchantmentCategory[]{SHIELD, BOW_AND_CROSSBOW});
        ItemHelper.addEnchantmentTypeToItemGroup((EnchantmentCategory)HORSE_ARMOR, (CreativeModeTab)CreativeModeTab.f_40753_);
    }

    private static void doClientSetup(FMLClientSetupEvent event) {
        RegistryHandlerClient.setup();
    }
}

