/*
 * Decompiled with CFR 0.152.
 */
package com.wonderfulenchantments;

import com.wonderfulenchantments.ClientEffects;
import com.wonderfulenchantments.Instances;
import com.wonderfulenchantments.renderers.HorseRendererReplacement;
import java.util.Map;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RegistryHandlerClient {
    public static void setup() {
        EntityRenderers.m_174036_((EntityType)EntityType.f_20457_, HorseRendererReplacement::new);
        ClientEffects clientEffects = Instances.CLIENT_EFFECTS;
        if (clientEffects.isEnchantedBookTextureReplacementEnabled() || clientEffects.isCombinedBookTextureReplacementEnabled()) {
            ItemProperties.register((Item)Items.f_42690_, (ResourceLocation)new ResourceLocation("book_type"), RegistryHandlerClient::enchantmentBookPredicate);
        }
    }

    private static float enchantmentBookPredicate(ItemStack itemStack, ClientLevel clientWorld, LivingEntity entity, int i) {
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)itemStack);
        boolean hasWonderfulEnchantments = false;
        boolean hasOtherEnchantments = false;
        for (Map.Entry enchantmentPair : enchantments.entrySet()) {
            Enchantment enchantment = (Enchantment)enchantmentPair.getKey();
            ResourceLocation enchantmentLocation = enchantment.getRegistryName();
            if (enchantmentLocation == null) continue;
            String enchantmentName = enchantmentLocation.m_135827_();
            if (enchantmentName.contains("wonderful_enchantments")) {
                hasWonderfulEnchantments = true;
            } else {
                hasOtherEnchantments = true;
            }
            if (!hasWonderfulEnchantments || !hasOtherEnchantments) continue;
            break;
        }
        ClientEffects clientEffects = Instances.CLIENT_EFFECTS;
        if (hasWonderfulEnchantments && clientEffects.isEnchantedBookTextureReplacementEnabled()) {
            return hasOtherEnchantments && clientEffects.isCombinedBookTextureReplacementEnabled() ? 2.0f : 1.0f;
        }
        return 0.0f;
    }
}

