/*
 * Decompiled with CFR 0.152.
 */
package com.wonderfulenchantments.curses;

import com.mlib.EquipmentSlots;
import com.mlib.LevelHelper;
import com.mlib.config.DoubleConfig;
import com.mlib.config.DurationConfig;
import com.mlib.config.IConfig;
import com.mlib.nbt.NBTHelper;
import com.wonderfulenchantments.Instances;
import com.wonderfulenchantments.curses.WonderfulCurse;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class CorrosionCurse
extends WonderfulCurse {
    private static final String CORROSION_TAG = "CurseOfCorrosionCounter";
    protected final DurationConfig damageCooldown;
    protected final DoubleConfig damageAmount;

    public CorrosionCurse() {
        super("corrosion_curse", Enchantment.Rarity.RARE, EnchantmentCategory.ARMOR, EquipmentSlots.ARMOR, "Corrosion");
        String cooldownComment = "Damage cooldown in seconds.";
        this.damageCooldown = new DurationConfig("damage_cooldown_duration", cooldownComment, false, 3.0, 1.0, 60.0);
        String damageComment = "Amount of damage dealt to the player every X seconds. (with each enchantment level)";
        this.damageAmount = new DoubleConfig("damage_amount", damageComment, false, 0.25, 0.0, 20.0);
        this.curseGroup.addConfigs(new IConfig[]{this.damageCooldown, this.damageAmount});
        this.setMaximumEnchantmentLevel(1);
        this.setDifferenceBetweenMinimumAndMaximum(40);
        this.setMinimumEnchantabilityCalculator(level -> 10);
    }

    @SubscribeEvent
    public static void onUpdate(LivingEvent.LivingUpdateEvent event) {
        boolean hasContactWithWater;
        LivingEntity entity = event.getEntityLiving();
        if (!(entity.f_19853_ instanceof ServerLevel)) {
            return;
        }
        CorrosionCurse corrosionCurse = Instances.CORROSION;
        int enchantmentLevel = corrosionCurse.getEnchantmentSum(entity.m_6168_());
        NBTHelper.IntegerData integerData = new NBTHelper.IntegerData(entity, CORROSION_TAG);
        integerData.set(value -> value + 1);
        boolean bl = hasContactWithWater = LevelHelper.isEntityOutsideWhenItIsRaining((Entity)entity) || entity.m_20069_();
        if (enchantmentLevel > 0 && hasContactWithWater && integerData.get() > corrosionCurse.damageCooldown.getDuration()) {
            integerData.set(Integer.valueOf(0));
            if (corrosionCurse.damageAmount.get() > 0.0) {
                entity.m_6469_(DamageSource.f_19312_, (float)((double)enchantmentLevel * corrosionCurse.damageAmount.get()));
            }
            corrosionCurse.damageArmor(entity);
        }
    }

    protected void damageArmor(LivingEntity entity) {
        for (EquipmentSlot equipmentSlotType : EquipmentSlots.ARMOR) {
            ItemStack itemStack = entity.m_6844_(equipmentSlotType);
            if (!this.hasEnchantment(itemStack)) continue;
            itemStack.m_41622_(1, entity, owner -> owner.m_21166_(equipmentSlotType));
        }
    }
}

