/*
 * Decompiled with CFR 0.152.
 */
package com.wonderfulenchantments.curses;

import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfig;
import com.wonderfulenchantments.Instances;
import com.wonderfulenchantments.curses.WonderfulCurse;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.DiggingEnchantment;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class FatigueCurse
extends WonderfulCurse {
    protected final DoubleConfig miningMultiplierConfig;

    public FatigueCurse() {
        super("fatigue_curse", Enchantment.Rarity.RARE, EnchantmentCategory.DIGGER, EquipmentSlot.MAINHAND, "Fatigue");
        String comment = "Mining speed reduction with each level.";
        this.miningMultiplierConfig = new DoubleConfig("multiplier", comment, false, 0.8, 0.1, 0.95);
        this.curseGroup.addConfig((IConfig)this.miningMultiplierConfig);
        this.setMaximumEnchantmentLevel(3);
        this.setDifferenceBetweenMinimumAndMaximum(40);
        this.setMinimumEnchantabilityCalculator(level -> 10);
    }

    public boolean m_5975_(Enchantment enchantment) {
        return !(enchantment instanceof DiggingEnchantment) && super.m_5975_(enchantment);
    }

    @SubscribeEvent
    public static void onBreakingBlock(PlayerEvent.BreakSpeed event) {
        FatigueCurse fatigueCurse = Instances.FATIGUE;
        int fatigueLevel = fatigueCurse.getEnchantmentLevel((LivingEntity)event.getPlayer());
        if (fatigueLevel > 0) {
            event.setNewSpeed(event.getNewSpeed() * fatigueCurse.getMiningMultiplier(fatigueLevel));
        }
    }

    protected float getMiningMultiplier(int fatigueLevel) {
        return (float)Math.pow(this.miningMultiplierConfig.get(), fatigueLevel);
    }
}

