/*
 * Decompiled with CFR 0.152.
 */
package com.wonderfulenchantments.curses;

import com.mlib.EquipmentSlots;
import com.mlib.attributes.AttributeHandler;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfig;
import com.wonderfulenchantments.Instances;
import com.wonderfulenchantments.curses.WonderfulCurse;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class SlownessCurse
extends WonderfulCurse {
    protected static final AttributeHandler ATTRIBUTE_HANDLER = new AttributeHandler("760f7b82-76c7-4875-821e-ef0579b881e0", "SlownessCurse", Attributes.f_22279_, AttributeModifier.Operation.MULTIPLY_TOTAL);
    protected final DoubleConfig slownessMultiplierConfig;

    public SlownessCurse() {
        super("slowness_curse", Enchantment.Rarity.RARE, EnchantmentCategory.ARMOR, EquipmentSlots.ARMOR, "Slowness");
        String comment = "Cumulative movement speed reduction with each item with this curse.";
        this.slownessMultiplierConfig = new DoubleConfig("multiplier", comment, false, 0.875, 0.1, 0.95);
        this.curseGroup.addConfig((IConfig)this.slownessMultiplierConfig);
        this.setMaximumEnchantmentLevel(1);
        this.setDifferenceBetweenMinimumAndMaximum(40);
        this.setMinimumEnchantabilityCalculator(level -> 10);
    }

    @SubscribeEvent
    public static void onEquipmentChange(LivingEquipmentChangeEvent event) {
        LivingEntity entity = event.getEntityLiving();
        ATTRIBUTE_HANDLER.setValueAndApply(entity, Instances.MOVEMENT_SLOWDOWN.getTotalSlownessMultiplier(entity) - 1.0);
    }

    private double getTotalSlownessMultiplier(LivingEntity entity) {
        return Math.pow(this.slownessMultiplierConfig.get(), this.getEnchantmentSum(entity, EquipmentSlots.ARMOR));
    }
}

