/*
 * Decompiled with CFR 0.152.
 */
package com.wonderfulenchantments.curses;

import com.mlib.CommonHelper;
import com.mlib.EquipmentSlots;
import com.mlib.LevelHelper;
import com.mlib.config.DurationConfig;
import com.mlib.config.IConfig;
import com.mlib.effects.EffectHelper;
import com.mlib.time.TimeHelper;
import com.wonderfulenchantments.Instances;
import com.wonderfulenchantments.curses.WonderfulCurse;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class VampirismCurse
extends WonderfulCurse {
    private static final MobEffect[] EFFECTS = new MobEffect[]{MobEffects.f_19613_, MobEffects.f_19597_, MobEffects.f_19612_};
    protected final DurationConfig effectDuration;
    protected final DurationConfig effectCooldown;

    public VampirismCurse() {
        super("vampirism_curse", Enchantment.Rarity.RARE, EnchantmentCategory.ARMOR, EquipmentSlots.ARMOR, "Vampirism");
        String durationComment = "Duration of negative effects. (in seconds)";
        this.effectDuration = new DurationConfig("effect_duration", durationComment, false, 30.0, 10.0, 300.0);
        String cooldownComment = "Cooldown between applying negative effects. (in seconds)";
        this.effectCooldown = new DurationConfig("effect_cooldown", cooldownComment, false, 2.0, 1.0, 60.0);
        this.curseGroup.addConfigs(new IConfig[]{this.effectDuration, this.effectCooldown});
        this.setMaximumEnchantmentLevel(1);
        this.setDifferenceBetweenMinimumAndMaximum(40);
        this.setMinimumEnchantabilityCalculator(level -> 10);
    }

    @SubscribeEvent
    public static void onUpdate(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        ServerLevel level = (ServerLevel)CommonHelper.castIfPossible(ServerLevel.class, (Object)entity.f_19853_);
        if (level == null) {
            return;
        }
        VampirismCurse vampirism = Instances.VAMPIRISM;
        int enchantmentLevel = vampirism.getEnchantmentSum(entity.m_6168_());
        if (enchantmentLevel > 0 && LevelHelper.isEntityOutsideDuringTheDay((Entity)entity)) {
            if (TimeHelper.hasServerTicksPassed((int)4)) {
                level.m_8767_((ParticleOptions)ParticleTypes.f_123762_, entity.m_20185_(), entity.m_20227_(0.5), entity.m_20189_(), 3 + enchantmentLevel, 0.125, 0.5, 0.125, 0.01);
            }
            if (TimeHelper.hasServerTicksPassed((int)vampirism.effectCooldown.getDuration())) {
                for (MobEffect effect : EFFECTS) {
                    EffectHelper.applyEffectIfPossible((LivingEntity)entity, (MobEffect)effect, (int)(vampirism.effectDuration.getDuration() * enchantmentLevel), (int)0);
                }
                entity.m_20254_(3 + 2 * enchantmentLevel);
            }
        }
    }
}

