/*
 * Decompiled with CFR 0.152.
 */
package com.wonderfulenchantments.enchantments;

import com.mlib.EquipmentSlots;
import com.mlib.TimeConverter;
import com.mlib.config.DurationConfig;
import com.mlib.config.IConfig;
import com.mlib.config.StringListConfig;
import com.wonderfulenchantments.Instances;
import com.wonderfulenchantments.RegistryHandler;
import com.wonderfulenchantments.enchantments.WonderfulEnchantment;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class AbsorberEnchantment
extends WonderfulEnchantment {
    protected final DurationConfig minimumEffectDuration;
    protected final StringListConfig forbiddenEffects;

    public AbsorberEnchantment() {
        super("absorber", Enchantment.Rarity.RARE, RegistryHandler.SHIELD, EquipmentSlots.BOTH_HANDS, "Absorber");
        String durationComment = "Minimum required duration to absorb an effect. (in seconds)";
        this.minimumEffectDuration = new DurationConfig("minimum_duration", durationComment, false, 2.5, 0.0, 60.0);
        String effectsComment = "MobEffects that can not be absorbed.";
        this.forbiddenEffects = new StringListConfig("forbidden_effects", effectsComment, false, new String[]{"majruszs_difficulty:bleeding", "majruszs_difficulty:infested"});
        this.enchantmentGroup.addConfigs(new IConfig[]{this.minimumEffectDuration, this.forbiddenEffects});
        this.setMaximumEnchantmentLevel(1);
        this.setDifferenceBetweenMinimumAndMaximum(15);
        this.setMinimumEnchantabilityCalculator(level -> 5 + 8 * level);
    }

    @SubscribeEvent
    public static void onApplyingEffect(PotionEvent.PotionApplicableEvent event) {
        LivingEntity entity = event.getEntityLiving();
        AbsorberEnchantment absorber = Instances.ABSORBER;
        MobEffectInstance effectInstance = event.getPotionEffect();
        MobEffect effect = effectInstance.m_19544_();
        if (absorber.isForbidden(effect) || effect.m_19486_() || effectInstance.m_19557_() < absorber.minimumEffectDuration.getDuration()) {
            return;
        }
        for (EquipmentSlot equipmentSlotType : EquipmentSlots.BOTH_HANDS) {
            ItemStack itemStack = entity.m_6844_(equipmentSlotType);
            if (!AbsorberEnchantment.absorbSucceed(itemStack)) continue;
            AbsorberEnchantment.damageShield(itemStack, entity, effectInstance);
            event.setResult(Event.Result.DENY);
            entity.f_19853_.m_5594_(null, entity.m_142538_(), SoundEvents.f_11911_, SoundSource.AMBIENT, 0.5f, 0.8f);
            break;
        }
    }

    protected static boolean absorbSucceed(ItemStack itemStack) {
        int enchantmentLevel = EnchantmentHelper.m_44843_((Enchantment)Instances.ABSORBER, (ItemStack)itemStack);
        return itemStack.m_41720_() instanceof ShieldItem && itemStack.m_41780_() == UseAnim.BLOCK && enchantmentLevel > 0;
    }

    protected static void damageShield(ItemStack shield, LivingEntity entity, MobEffectInstance effectInstance) {
        double amplifierDamage = effectInstance.m_19564_();
        double durationDamage = (double)effectInstance.m_19557_() / (double)TimeConverter.secondsToTicks((double)60.0);
        EquipmentSlot slotType = entity.m_21205_() == shield ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
        shield.m_41622_((int)(amplifierDamage + durationDamage + 1.0), entity, e -> e.m_21166_(slotType));
    }

    protected boolean isForbidden(MobEffect effect) {
        ResourceLocation effectRegistryName = effect.getRegistryName();
        return effectRegistryName != null && this.forbiddenEffects.contains(effectRegistryName.toString());
    }
}

