/*
 * Decompiled with CFR 0.152.
 */
package com.wonderfulenchantments.enchantments;

import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfig;
import com.mlib.damage.DamageHelper;
import com.mlib.entities.EntityHelper;
import com.wonderfulenchantments.Instances;
import com.wonderfulenchantments.RegistryHandler;
import com.wonderfulenchantments.enchantments.WonderfulEnchantment;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class DeathWishEnchantment
extends WonderfulEnchantment {
    protected final DoubleConfig maximumDamageMultiplier;
    protected final DoubleConfig vulnerabilityMultiplier;

    public DeathWishEnchantment() {
        super("death_wish", Enchantment.Rarity.RARE, RegistryHandler.MELEE_WEAPON, EquipmentSlot.MAINHAND, "DeathWish");
        String damageComment = "Maximum damage bonus player can get from this enchantment. (at full health - 0% * value, at half health - 50% * value, at 0 health - 100% * value)";
        this.maximumDamageMultiplier = new DoubleConfig("maximum_damage_multiplier", damageComment, false, 1.0, 0.01, 10.0);
        String vulnerabilityComment = "Whenever the owner takes damage, the damage is multiplied by this value.";
        this.vulnerabilityMultiplier = new DoubleConfig("vulnerability_multiplier", vulnerabilityComment, false, 1.25, 1.0, 10.0);
        this.enchantmentGroup.addConfigs(new IConfig[]{this.maximumDamageMultiplier, this.vulnerabilityMultiplier});
        this.setMaximumEnchantmentLevel(1);
        this.setDifferenceBetweenMinimumAndMaximum(40);
        this.setMinimumEnchantabilityCalculator(level -> 12);
    }

    @SubscribeEvent
    public static void onDamageDealt(LivingHurtEvent event) {
        LivingEntity target;
        DeathWishEnchantment deathWish = Instances.DEATH_WISH;
        LivingEntity attacker = (LivingEntity)DamageHelper.castEntityIfPossible(LivingEntity.class, (DamageSource)event.getSource());
        if (attacker != null && deathWish.hasEnchantment(attacker)) {
            event.setAmount(event.getAmount() * deathWish.getDamageMultiplier(attacker));
        }
        if (deathWish.hasEnchantment(target = event.getEntityLiving())) {
            event.setAmount(event.getAmount() * deathWish.getVulnerabilityMultiplier());
        }
    }

    private float getDamageMultiplier(LivingEntity entity) {
        return (float)(1.0 + EntityHelper.getMissingHealthRatio((LivingEntity)entity) * this.maximumDamageMultiplier.get());
    }

    private float getVulnerabilityMultiplier() {
        return this.vulnerabilityMultiplier.get().floatValue();
    }
}

