/*
 * Decompiled with CFR 0.152.
 */
package com.wonderfulenchantments.enchantments;

import com.mlib.Random;
import com.mlib.attributes.AttributeHandler;
import com.mlib.config.AvailabilityConfig;
import com.mlib.config.DoubleConfig;
import com.mlib.config.DurationConfig;
import com.mlib.config.IConfig;
import com.wonderfulenchantments.Instances;
import com.wonderfulenchantments.enchantments.WonderfulEnchantment;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class DodgeEnchantment
extends WonderfulEnchantment {
    private static final AttributeHandler ATTRIBUTE_HANDLER = new AttributeHandler("ad3e064e-e9f6-4747-a86b-46dc4e2a1444", "KnockBackImmunityTime", Attributes.f_22278_, AttributeModifier.Operation.ADDITION);
    private static final String DODGE_TAG = "KnockbackImmunityCounter";
    protected final DoubleConfig dodgeChancePerLevel;
    protected final DoubleConfig damageAmountFactor;
    protected final DurationConfig immunityTime;
    protected final AvailabilityConfig spawnParticles;

    public DodgeEnchantment() {
        super("dodge", Enchantment.Rarity.RARE, EnchantmentCategory.ARMOR_LEGS, EquipmentSlot.LEGS, "Dodge");
        String chanceComment = "Chance to completely ignore any damage source per enchantment level.";
        String damageComment = "Amount of damage converted to pants damage. (for example if this factor is equal 0.5 and player took 10 damage so its pants takes 5 damage)";
        String immunityComment = "Duration of knockback immunity after successful dodge. (in seconds)";
        String particlesComment = "Should the enchantment particles be visible?";
        this.dodgeChancePerLevel = new DoubleConfig("dodge_chance", chanceComment, false, 0.125, 0.01, 0.4);
        this.damageAmountFactor = new DoubleConfig("damage_factor", damageComment, false, 0.5, 0.0, 10.0);
        this.immunityTime = new DurationConfig("immunity_duration", immunityComment, false, 3.0, 0.0, 30.0);
        this.spawnParticles = new AvailabilityConfig("particles", particlesComment, false, true);
        this.enchantmentGroup.addConfigs(new IConfig[]{this.dodgeChancePerLevel, this.damageAmountFactor, this.immunityTime, this.spawnParticles});
        this.setMaximumEnchantmentLevel(2);
        this.setDifferenceBetweenMinimumAndMaximum(20);
        this.setMinimumEnchantabilityCalculator(level -> 14 * level);
    }

    @SubscribeEvent
    public static void onEntityHurt(LivingDamageEvent event) {
        LivingEntity entity = event.getEntityLiving();
        ItemStack pants = entity.m_6844_(EquipmentSlot.LEGS);
        CompoundTag data = entity.getPersistentData();
        DodgeEnchantment dodge = Instances.DODGE;
        int dodgeLevel = EnchantmentHelper.m_44843_((Enchantment)dodge, (ItemStack)pants);
        if (dodgeLevel <= 0 || !(entity.f_19853_ instanceof ServerLevel)) {
            return;
        }
        if (!Random.tryChance((double)((double)dodgeLevel * dodge.dodgeChancePerLevel.get()))) {
            return;
        }
        DodgeEnchantment.updateImmunity(entity, dodge.immunityTime.getDuration());
        DodgeEnchantment.spawnParticlesAndPlaySounds(entity);
        if (dodge.damageAmountFactor.get() > 0.0) {
            pants.m_41622_(Math.max((int)((double)event.getAmount() * dodge.damageAmountFactor.get()), 1), entity, owner -> owner.m_21166_(EquipmentSlot.LEGS));
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onUpdate(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        CompoundTag data = entity.getPersistentData();
        DodgeEnchantment.updateImmunity(entity, data.m_128451_(DODGE_TAG) - 1);
    }

    protected static void updateImmunity(LivingEntity entity, int duration) {
        CompoundTag data = entity.getPersistentData();
        data.m_128405_(DODGE_TAG, Math.max(0, duration));
        ATTRIBUTE_HANDLER.setValueAndApply(entity, data.m_128451_(DODGE_TAG) > 0 ? 1.0 : 0.0);
    }

    protected static void spawnParticlesAndPlaySounds(LivingEntity entity) {
        ServerLevel world = (ServerLevel)entity.f_19853_;
        if (Instances.DODGE.spawnParticles.isEnabled()) {
            for (double d = 0.0; d < 3.0; d += 1.0) {
                Vec3 emitterPosition = new Vec3(0.0, (double)entity.m_20206_() * 0.25 * (d + 1.0), 0.0).m_82549_(entity.m_20182_());
                for (int i = 0; i < 2; ++i) {
                    world.m_8767_((ParticleOptions)(i == 0 ? ParticleTypes.f_123777_ : ParticleTypes.f_123755_), emitterPosition.f_82479_, emitterPosition.f_82480_, emitterPosition.f_82481_, 8 * (i + 1), 0.125, 0.0, 0.125, (i == 0 ? 0.1 : 0.4) * 0.075);
                }
            }
        }
        world.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11914_, SoundSource.AMBIENT, 1.0f, 1.0f);
    }
}

