/*
 * Decompiled with CFR 0.152.
 */
package com.wonderfulenchantments.enchantments;

import com.mlib.LevelHelper;
import com.mlib.MajruszLibrary;
import com.mlib.config.DoubleConfig;
import com.mlib.config.DurationConfig;
import com.mlib.config.IConfig;
import com.wonderfulenchantments.Instances;
import com.wonderfulenchantments.enchantments.WonderfulEnchantment;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ElderGaurdianFavorEnchantment
extends WonderfulEnchantment {
    private static final String LINK_TAG = "ElderGuardianFavorLinkedEntityID";
    private static final String LINK_COUNTER_TAG = "ElderGuardianFavorCounter";
    protected final DurationConfig beamCooldown;
    protected final DoubleConfig beamDamage;
    protected final DoubleConfig waterMultiplier;

    public ElderGaurdianFavorEnchantment() {
        super("elder_guardian_favor", Enchantment.Rarity.RARE, EnchantmentCategory.TRIDENT, EquipmentSlot.MAINHAND, "ElderGuardianFavor");
        String cooldown_comment = "Duration how long entities are linked before dealing damage.";
        String damage_comment = "Damage dealt by this enchantment.";
        String water_comment = "Damage multiplier when both entities are in water.";
        this.beamCooldown = new DurationConfig("beam_cooldown", cooldown_comment, false, 4.0, 1.0, 60.0);
        this.beamDamage = new DoubleConfig("beam_damage", damage_comment, false, 6.0, 1.0, 100.0);
        this.waterMultiplier = new DoubleConfig("water_multiplier", water_comment, false, 1.5, 1.0, 10.0);
        this.enchantmentGroup.addConfigs(new IConfig[]{this.beamCooldown, this.beamDamage, this.waterMultiplier});
        this.setMaximumEnchantmentLevel(1);
        this.setDifferenceBetweenMinimumAndMaximum(20);
        this.setMinimumEnchantabilityCalculator(level -> 14 * level);
    }

    @SubscribeEvent
    public static void onHit(LivingHurtEvent event) {
        DamageSource damageSource = event.getSource();
        if (!(damageSource.m_7639_() instanceof LivingEntity) || !(damageSource.m_7640_() instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)damageSource.m_7639_();
        LivingEntity target = event.getEntityLiving();
        int enchantmentLevel = EnchantmentHelper.m_44843_((Enchantment)Instances.ELDER_GAURDIAN_FAVOR, (ItemStack)attacker.m_21205_());
        ElderGaurdianFavorEnchantment.connectEntities(attacker, target, enchantmentLevel);
    }

    @SubscribeEvent
    public static void onUpdate(LivingEvent.LivingUpdateEvent event) {
        LivingEntity attacker = event.getEntityLiving();
        CompoundTag data = attacker.getPersistentData();
        int counter = data.m_128451_(LINK_COUNTER_TAG) - 1;
        if (counter < 0 || !(attacker.f_19853_ instanceof ServerLevel)) {
            return;
        }
        data.m_128405_(LINK_COUNTER_TAG, counter);
        ElderGaurdianFavorEnchantment enchantment = Instances.ELDER_GAURDIAN_FAVOR;
        int targetID = data.m_128451_(LINK_TAG);
        ServerLevel world = (ServerLevel)attacker.f_19853_;
        Entity targetEntity = world.m_6815_(targetID);
        if (!(targetEntity instanceof LivingEntity)) {
            return;
        }
        LivingEntity target = (LivingEntity)targetEntity;
        if (counter > 0) {
            ElderGaurdianFavorEnchantment.spawnParticles(attacker, target, world);
        } else {
            boolean areEntitiesInWater = !(!target.m_20069_() && !LevelHelper.isEntityOutsideWhenItIsRaining((Entity)target) || !attacker.m_20069_() && !LevelHelper.isEntityOutsideWhenItIsRaining((Entity)attacker));
            world.m_6263_(null, target.m_20185_(), target.m_20188_(), target.m_20189_(), SoundEvents.f_11983_, SoundSource.AMBIENT, 0.5f, 1.8f);
            target.m_6469_(DamageSource.f_19319_, (float)((areEntitiesInWater ? enchantment.waterMultiplier.get() : 1.0) * enchantment.beamDamage.get()));
        }
    }

    protected static void connectEntities(LivingEntity attacker, LivingEntity target, int enchantmentLevel) {
        CompoundTag data = attacker.getPersistentData();
        if (data.m_128451_(LINK_COUNTER_TAG) > 0 || enchantmentLevel == 0) {
            return;
        }
        data.m_128405_(LINK_TAG, target.m_142049_());
        data.m_128405_(LINK_COUNTER_TAG, Instances.ELDER_GAURDIAN_FAVOR.beamCooldown.getDuration());
    }

    protected static void spawnParticles(LivingEntity attacker, LivingEntity target, ServerLevel world) {
        Vec3 difference = new Vec3(attacker.m_20185_() - target.m_20185_(), attacker.m_20227_(0.5) - target.m_20227_(0.5), attacker.m_20189_() - target.m_20189_());
        Vec3 normalized = difference.m_82541_();
        for (double factor = 0.0; factor < difference.m_82553_(); factor += 1.0 + MajruszLibrary.RANDOM.nextDouble() * 0.8999999999999999) {
            double x = attacker.m_20185_() - normalized.f_82479_ * factor;
            double y = attacker.m_20227_(0.5) - normalized.f_82480_ * factor;
            double z = attacker.m_20189_() - normalized.f_82481_ * factor;
            world.m_8767_((ParticleOptions)ParticleTypes.f_123795_, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
            world.m_8767_((ParticleOptions)ParticleTypes.f_123772_, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

