/*
 * Decompiled with CFR 0.152.
 */
package com.wonderfulenchantments.enchantments;

import com.mlib.CommonHelper;
import com.mlib.EquipmentSlots;
import com.mlib.MajruszLibrary;
import com.mlib.Random;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfig;
import com.wonderfulenchantments.Instances;
import com.wonderfulenchantments.enchantments.WonderfulEnchantment;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class EnlightenmentEnchantment
extends WonderfulEnchantment {
    protected final DoubleConfig experienceMultiplier;

    public EnlightenmentEnchantment() {
        super("enlightenment", Enchantment.Rarity.RARE, EnchantmentCategory.ARMOR, EquipmentSlots.ARMOR, "Enlightenment");
        String experienceComment = "Increases experience from all sources by that multiplier per enchantment level.";
        this.experienceMultiplier = new DoubleConfig("experience_multiplier", experienceComment, false, 0.25, 0.01, 10.0);
        this.enchantmentGroup.addConfigs(new IConfig[]{this.experienceMultiplier});
        this.setMaximumEnchantmentLevel(2);
        this.setDifferenceBetweenMinimumAndMaximum(20);
        this.setMinimumEnchantabilityCalculator(level -> 6 + level * 12);
    }

    @SubscribeEvent
    public static void onXPPickUp(PlayerXpEvent.PickupXp event) {
        EnlightenmentEnchantment enlightenment = Instances.ENLIGHTENMENT;
        Player player = event.getPlayer();
        int enlightenmentSum = enlightenment.getEnchantmentSum((LivingEntity)player, EquipmentSlots.ARMOR);
        if (enlightenmentSum > 0) {
            player.m_6756_(enlightenment.getRandomizedExperience(enlightenmentSum, event.getOrb()));
        }
    }

    @SubscribeEvent
    public static void onEquipmentChanged(LivingEquipmentChangeEvent event) {
        EnlightenmentEnchantment enlightenment = Instances.ENLIGHTENMENT;
        ServerPlayer player = (ServerPlayer)CommonHelper.castIfPossible(ServerPlayer.class, (Object)event.getEntityLiving());
        if (player != null && enlightenment.getEnchantmentSum((LivingEntity)player, EquipmentSlots.ARMOR) == 8) {
            Instances.BASIC_TRIGGER.trigger(player, "enlightenment_8");
        }
    }

    protected int getRandomizedExperience(int enlightenmentSum, ExperienceOrb experienceOrb) {
        double maximumAmountOfExperiencePoints = this.experienceMultiplier.get() * (double)enlightenmentSum * (double)experienceOrb.m_20801_();
        return Random.randomizeExperience((double)(maximumAmountOfExperiencePoints * MajruszLibrary.RANDOM.nextDouble()));
    }
}

