/*
 * Decompiled with CFR 0.152.
 */
package com.wonderfulenchantments.enchantments;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.mlib.CommonHelper;
import com.mlib.EquipmentSlots;
import com.mlib.MajruszLibrary;
import com.mlib.Random;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfig;
import com.mlib.config.IntegerConfig;
import com.mlib.math.VectorHelper;
import com.mlib.triggers.BasicTrigger;
import com.wonderfulenchantments.Instances;
import com.wonderfulenchantments.WonderfulEnchantments;
import com.wonderfulenchantments.enchantments.WonderfulEnchantment;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber
public class FanaticEnchantment
extends WonderfulEnchantment {
    private static final ResourceLocation SPECIAL_LOOT_TABLE = WonderfulEnchantments.getLocation("gameplay/fishing/fishing_fanatic_extra");
    protected final DoubleConfig levelIncreaseChanceMultiplier;
    protected final DoubleConfig highLevelIncreaseChanceMultiplier;
    protected final DoubleConfig extraLootChance;
    protected final DoubleConfig rainingMultiplier;
    protected final DoubleConfig damageBonus;
    protected final IntegerConfig specialDropMinimumLevel;
    protected final DoubleConfig specialDropChance;

    public FanaticEnchantment() {
        super("fishing_fanatic", Enchantment.Rarity.UNCOMMON, EnchantmentCategory.FISHING_ROD, EquipmentSlots.BOTH_HANDS, "FishingFanatic");
        String increaseComment = "Chance for increasing enchantment level per every missing level to 6th level. (for example if this value is equal 0.01 then to get 1st level you have 6 * 0.01 = 6% chance, to get 2nd level ( 6-1 ) * 0.01 = 5% chance)";
        this.levelIncreaseChanceMultiplier = new DoubleConfig("level_increase_chance", increaseComment, false, 0.01, 1.0E-4, 1.0);
        String highIncreaseComment = "Chance for increasing enchantment level per every missing level from 6th to 8th level. (for example if this value is equal 0.002 then to get 7th level you have 2 * 0.002 = 0.4% chance and to get 8th level 1 * 0.002 = 0.2% chance)";
        this.highLevelIncreaseChanceMultiplier = new DoubleConfig("high_level_increase_chance", highIncreaseComment, false, 0.002, 1.0E-4, 1.0);
        String lootComment = "Independent chance for extra loot with every enchantment level.";
        this.extraLootChance = new DoubleConfig("extra_loot_chance", lootComment, false, 0.33333, 0.01, 1.0);
        String rainingComment = "Chance multiplier when player is fishing while it is raining.";
        this.rainingMultiplier = new DoubleConfig("raining_multiplier", rainingComment, false, 2.0, 1.0, 10.0);
        String damageComment = "Amount of extra damage dealt by the fishing rod for every enchantment level.";
        this.damageBonus = new DoubleConfig("damage_bonus", damageComment, false, 1.0, 0.0, 5.0);
        String minimumComment = "Minimum required level of Fishing Fanatic to have a chance to drop special items.";
        this.specialDropMinimumLevel = new IntegerConfig("special_minimum_level", minimumComment, false, 7, 1, 8);
        String specialComment = "Chance to drop special items instead of regular one. (chance is separate for each item)";
        this.specialDropChance = new DoubleConfig("special_drop_chance", specialComment, false, 0.05, 0.0, 1.0);
        this.enchantmentGroup.addConfigs(new IConfig[]{this.levelIncreaseChanceMultiplier, this.highLevelIncreaseChanceMultiplier, this.extraLootChance, this.rainingMultiplier, this.damageBonus, this.specialDropMinimumLevel, this.specialDropChance});
        this.setMaximumEnchantmentLevel(8);
        this.setDifferenceBetweenMinimumAndMaximum(20);
        this.setMinimumEnchantabilityCalculator(level -> 10 * level);
    }

    public float m_7335_(int level, MobType creature) {
        return (float)((double)level * this.damageBonus.get());
    }

    public Component m_44700_(int level) {
        if (level == this.m_6586_()) {
            TranslatableComponent output = new TranslatableComponent("wonderful_enchantments.true_level");
            return output.m_130946_(" ").m_7220_((Component)new TranslatableComponent(this.m_44704_())).m_130940_(ChatFormatting.GRAY);
        }
        return super.m_44700_(level);
    }

    public boolean m_6591_() {
        return true;
    }

    @SubscribeEvent
    public static void onFishedItem(ItemFishedEvent event) {
        boolean isRaining;
        Player player = event.getPlayer();
        Level level = player.f_19853_;
        FanaticEnchantment enchantment = Instances.FISHING_FANATIC;
        LootContext lootContext = FanaticEnchantment.generateLootContext(player);
        LootTable standardLootTable = FanaticEnchantment.getFishingLootTable();
        LootTable specialLootTable = FanaticEnchantment.getLootTable(SPECIAL_LOOT_TABLE);
        int fanaticLevel = EnchantmentHelper.m_44843_((Enchantment)enchantment, (ItemStack)FanaticEnchantment.getFishingRodItemStack(player));
        HashMultiset rewards = HashMultiset.create();
        rewards.add((Object)((ItemStack)event.getDrops().get(0)).m_41786_().getString());
        int extraRewardsCounter = 0;
        for (int i = 0; i < fanaticLevel && enchantment.availabilityConfig.isEnabled(); ++i) {
            if (!Random.tryChance((double)enchantment.extraLootChance.get())) continue;
            LootTable lootTable = enchantment.shouldDropSpecialLoot(fanaticLevel) ? specialLootTable : standardLootTable;
            for (ItemStack extraReward : lootTable.m_79129_(lootContext)) {
                FanaticEnchantment.spawnReward(extraReward, player, level, event.getHookEntity());
                rewards.add((Object)extraReward.m_41786_().getString());
                ++extraRewardsCounter;
            }
        }
        boolean bl = isRaining = level instanceof ServerLevel && level.m_46471_();
        if (FanaticEnchantment.tryIncreaseFishingFanaticLevel(player, isRaining)) {
            player.m_5661_((Component)new TranslatableComponent("wonderful_enchantments.fanatic_level_up").m_130940_(ChatFormatting.BOLD), true);
        } else if (rewards.size() > 1) {
            FanaticEnchantment.notifyPlayerAboutRewards((Multiset<String>)rewards, player);
        }
        event.damageRodBy(event.getRodDamage() + extraRewardsCounter);
        level.m_7967_((Entity)new ExperienceOrb(level, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_() + 0.5, extraRewardsCounter + MajruszLibrary.RANDOM.nextInt(2 * extraRewardsCounter + 1)));
    }

    protected static LootContext generateLootContext(Player player) {
        LootContext.Builder lootContextBuilder = new LootContext.Builder((ServerLevel)player.f_19853_);
        lootContextBuilder.m_78972_(LootContextParams.f_81463_, (Object)player.m_21205_()).m_78977_(MajruszLibrary.RANDOM).m_78963_(player.m_36336_()).m_78972_(LootContextParams.f_81460_, (Object)player.m_20182_());
        return lootContextBuilder.m_78975_(LootContextParamSets.f_81414_);
    }

    protected static LootTable getLootTable(ResourceLocation location) {
        return ServerLifecycleHooks.getCurrentServer().m_129898_().m_79217_(location);
    }

    protected static LootTable getFishingLootTable() {
        return FanaticEnchantment.getLootTable(BuiltInLootTables.f_78720_);
    }

    protected static void spawnReward(ItemStack reward, Player player, Level level, FishingHook hook) {
        Vec3 spawnPosition = hook.m_20182_().m_82549_(Random.getRandomVector3d((double)-0.25, (double)0.25, (double)0.125, (double)0.5, (double)-0.25, (double)0.25));
        ItemEntity itemEntity = new ItemEntity(level, spawnPosition.f_82479_, spawnPosition.f_82480_, spawnPosition.f_82481_, reward);
        Vec3 motion = player.m_20182_().m_82546_(itemEntity.m_20182_()).m_82542_(0.1, 0.1, 0.1);
        itemEntity.m_20256_(motion.m_82520_(0.0, Math.pow(VectorHelper.length((Vec3)motion), 0.5) * 0.25, 0.0));
        level.m_7967_((Entity)itemEntity);
    }

    protected static boolean tryIncreaseFishingFanaticLevel(Player player, boolean isRaining) {
        FanaticEnchantment enchantment = Instances.FISHING_FANATIC;
        ItemStack fishingRod = FanaticEnchantment.getFishingRodItemStack(player);
        int enchantmentLevel = EnchantmentHelper.m_44843_((Enchantment)enchantment, (ItemStack)fishingRod);
        if (enchantment.shouldLevelBeIncreased(enchantmentLevel, isRaining)) {
            if (enchantmentLevel == 0) {
                fishingRod.m_41663_((Enchantment)enchantment, 1);
            } else {
                ListTag nbt = fishingRod.m_41785_();
                for (int i = 0; i < nbt.size(); ++i) {
                    CompoundTag enchantmentData = nbt.m_128728_(i);
                    String enchantmentID = enchantmentData.m_128461_("id");
                    if (!enchantmentID.contains("fishing_fanatic")) continue;
                    enchantmentData.m_128405_("lvl", enchantmentLevel + 1);
                    break;
                }
                fishingRod.m_41700_("Enchantments", (Tag)nbt);
            }
            ServerPlayer serverPlayer = (ServerPlayer)CommonHelper.castIfPossible(ServerPlayer.class, (Object)player);
            if (serverPlayer != null) {
                BasicTrigger basicTrigger = Instances.BASIC_TRIGGER;
                if (isRaining) {
                    basicTrigger.trigger(serverPlayer, "nothing_can_stop_me");
                }
                if (enchantmentLevel + 1 == 1) {
                    basicTrigger.trigger(serverPlayer, "fishing_fanatic");
                }
                if (enchantmentLevel + 1 == 8) {
                    basicTrigger.trigger(serverPlayer, "fishing_fanatic_true");
                }
            }
            return true;
        }
        return false;
    }

    protected static ItemStack getFishingRodItemStack(Player player) {
        ItemStack mainHandItemStack = player.m_21205_();
        ItemStack offHandItemStack = player.m_21206_();
        return mainHandItemStack.m_41720_() instanceof FishingRodItem ? mainHandItemStack : offHandItemStack;
    }

    protected static void notifyPlayerAboutRewards(Multiset<String> rewards, Player player) {
        TextComponent message = new TextComponent(ChatFormatting.WHITE + "(");
        ImmutableList rewardList = Multisets.copyHighestCountFirst(rewards).elementSet().asList();
        for (int i = 0; i < rewardList.size(); ++i) {
            message.m_7220_((Component)new TextComponent((i == 0 ? ChatFormatting.WHITE : ChatFormatting.GOLD) + (String)rewardList.get(i)));
            if (rewards.count(rewardList.get(i)) > 1) {
                message.m_7220_((Component)new TextComponent(ChatFormatting.GOLD + " x" + rewards.count(rewardList.get(i))));
            }
            if (i == rewardList.size() - 1) continue;
            message.m_7220_((Component)new TextComponent(ChatFormatting.WHITE + ", "));
        }
        message.m_7220_((Component)new TextComponent(ChatFormatting.WHITE + ")"));
        player.m_5661_((Component)message, true);
    }

    protected double getChanceForLevelIncrease(int level) {
        if (level < 6) {
            return (double)(6 - level) * this.levelIncreaseChanceMultiplier.get();
        }
        return (double)(this.m_6586_() - level) * this.highLevelIncreaseChanceMultiplier.get();
    }

    protected double getChanceForLevelIncrease(int level, boolean isRaining) {
        return this.getChanceForLevelIncrease(level) * (isRaining ? this.rainingMultiplier.get() : 1.0);
    }

    protected boolean shouldLevelBeIncreased(int currentLevel, boolean isRaining) {
        return !this.isDisabled() && Random.tryChance((double)this.getChanceForLevelIncrease(currentLevel, isRaining));
    }

    protected boolean shouldDropSpecialLoot(int level) {
        return this.specialDropMinimumLevel.get() <= level && Random.tryChance((double)this.specialDropChance.get());
    }
}

