/*
 * Decompiled with CFR 0.152.
 */
package com.wonderfulenchantments.enchantments;

import com.mlib.EquipmentSlots;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfig;
import com.wonderfulenchantments.Instances;
import com.wonderfulenchantments.RegistryHandler;
import com.wonderfulenchantments.enchantments.WonderfulEnchantment;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class FuseCutterEnchantment
extends WonderfulEnchantment {
    protected final DoubleConfig maximumOffset;

    public FuseCutterEnchantment() {
        super("fuse_cutter", Enchantment.Rarity.UNCOMMON, RegistryHandler.SHIELD, EquipmentSlots.BOTH_HANDS, "FuseCutter");
        String distanceComment = "Maximum distance in blocks from player to entity.";
        this.maximumOffset = new DoubleConfig("maximum_offset", distanceComment, false, 6.0, 1.0, 100.0);
        this.enchantmentGroup.addConfigs(new IConfig[]{this.maximumOffset});
        this.setMaximumEnchantmentLevel(1);
        this.setDifferenceBetweenMinimumAndMaximum(32);
        this.setMinimumEnchantabilityCalculator(level -> 8);
    }

    @SubscribeEvent
    public static void onExplosion(ExplosionEvent.Start explosionEvent) {
        FuseCutterEnchantment enchantment = Instances.FUSE_CUTTER;
        Explosion explosion = explosionEvent.getExplosion();
        if (!enchantment.isAnyoneBlockingWithFuseCutter(explosionEvent.getWorld(), explosion.getPosition())) {
            return;
        }
        enchantment.cancelExplosion((ExplosionEvent)explosionEvent);
    }

    protected boolean isAnyoneBlockingWithFuseCutter(Level world, Vec3 position) {
        double x = position.f_82479_;
        double y = position.f_82480_;
        double z = position.f_82481_;
        double offset = this.maximumOffset.get();
        AABB axisAligned = new AABB(x, y, z, x, y, z).m_82400_(offset);
        for (LivingEntity livingEntity : world.m_45976_(LivingEntity.class, axisAligned)) {
            if (!livingEntity.m_21254_() || !this.hasEnchantment(livingEntity.m_6844_(EquipmentSlot.MAINHAND)) && !this.hasEnchantment(livingEntity.m_6844_(EquipmentSlot.OFFHAND))) continue;
            return true;
        }
        return false;
    }

    protected void cancelExplosion(ExplosionEvent explosionEvent) {
        explosionEvent.setCanceled(true);
        if (!(explosionEvent.getWorld() instanceof ServerLevel)) {
            return;
        }
        ServerLevel world = (ServerLevel)explosionEvent.getWorld();
        Explosion explosion = explosionEvent.getExplosion();
        Vec3 position = explosion.getPosition();
        for (int i = 0; i < 2; ++i) {
            world.m_8767_((ParticleOptions)(i == 0 ? ParticleTypes.f_123755_ : ParticleTypes.f_123762_), position.f_82479_, position.f_82480_ + 0.5, position.f_82481_, 16 * i, 0.125, 0.25, 0.125, 0.025);
        }
        world.m_6263_(null, position.f_82479_, position.f_82480_, position.f_82481_, SoundEvents.f_11914_, SoundSource.AMBIENT, 1.0f, 1.0f);
    }
}

