/*
 * Decompiled with CFR 0.152.
 */
package com.wonderfulenchantments.enchantments;

import com.mlib.TimeConverter;
import com.mlib.config.DoubleConfig;
import com.mlib.config.DurationConfig;
import com.mlib.config.IConfig;
import com.mlib.nbt.NBTHelper;
import com.mlib.network.message.FloatMessage;
import com.mlib.time.TimeHelper;
import com.wonderfulenchantments.Instances;
import com.wonderfulenchantments.PacketHandler;
import com.wonderfulenchantments.enchantments.WonderfulEnchantment;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber
public class GottaMineFastEnchantment
extends WonderfulEnchantment {
    private static final String COUNTER_TAG = "GottaMineFastCounter";
    private static final String MINING_MULTIPLIER_TAG = "GottaMineFastMultiplier";
    protected final DoubleConfig exponent;
    protected final DurationConfig maximumDuration;
    protected boolean isMining = false;

    public GottaMineFastEnchantment() {
        super("gotta_mine_fast", Enchantment.Rarity.RARE, EnchantmentCategory.DIGGER, EquipmentSlot.MAINHAND, "GottaMineFast");
        String exponentComment = "Duration is raised to this exponent. (for example exponent = 1.5 and after two minutes bonus is equal 2.0 ^ 1.5 = 2.82 (total 3.82))";
        this.exponent = new DoubleConfig("exponent", exponentComment, false, 1.5849625007, 1.01, 5.0);
        String durationComment = "Maximum duration increasing mining speed. (in seconds)";
        this.maximumDuration = new DurationConfig("maximum_duration", durationComment, false, 120.0, 1.0, 3600.0);
        this.enchantmentGroup.addConfigs(new IConfig[]{this.exponent, this.maximumDuration});
        this.setMaximumEnchantmentLevel(1);
        this.setDifferenceBetweenMinimumAndMaximum(25);
        this.setMinimumEnchantabilityCalculator(level -> 15 * level);
    }

    @SubscribeEvent
    public static void whenHoldingMouseButton(InputEvent.MouseInputEvent event) {
        if (event.getButton() == 0) {
            Instances.GOTTA_MINE_FAST.isMining = event.getAction() == 1;
        }
    }

    @SubscribeEvent
    public static void onUpdate(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (player.f_19853_ instanceof ServerLevel || !TimeHelper.isEndPhase((TickEvent)event)) {
            return;
        }
        GottaMineFastEnchantment gottaMineFast = Instances.GOTTA_MINE_FAST;
        NBTHelper.IntegerData counterData = new NBTHelper.IntegerData((LivingEntity)player, COUNTER_TAG);
        counterData.set(value -> gottaMineFast.isMining ? value + 1 : 0);
        if (TimeHelper.hasClientTicksPassed((int)20)) {
            gottaMineFast.sendMultiplierMessage(counterData);
        }
    }

    @SubscribeEvent
    public static void onBreakingBlock(PlayerEvent.BreakSpeed event) {
        GottaMineFastEnchantment gottaMineFast = Instances.GOTTA_MINE_FAST;
        Player player = event.getPlayer();
        if (gottaMineFast.hasEnchantment((LivingEntity)player)) {
            NBTHelper.FloatData miningData = new NBTHelper.FloatData((LivingEntity)player, MINING_MULTIPLIER_TAG);
            NBTHelper.IntegerData counterData = new NBTHelper.IntegerData((LivingEntity)player, COUNTER_TAG);
            float miningMultiplier = gottaMineFast.getMiningMultiplier(counterData.get());
            event.setNewSpeed(event.getNewSpeed() * (1.0f + (miningMultiplier > 0.0f ? miningMultiplier : miningData.get().floatValue())));
        }
    }

    public void sendMultiplierMessage(NBTHelper.IntegerData counterData) {
        PacketHandler.CHANNEL.sendToServer((Object)new MultiplierMessage(this.getMiningMultiplier(counterData.get())));
    }

    protected float getMiningMultiplier(int miningTicks) {
        return (float)Math.pow((float)Math.min(miningTicks, this.maximumDuration.getDuration()) / (float)TimeConverter.minutesToTicks((double)1.0), this.exponent.get());
    }

    public static class MultiplierMessage
    extends FloatMessage {
        public MultiplierMessage(float value) {
            super(value);
        }

        public MultiplierMessage(FriendlyByteBuf buffer) {
            super(buffer);
        }

        public void receiveMessage(ServerPlayer sender, NetworkEvent.Context context) {
            NBTHelper.FloatData miningData = new NBTHelper.FloatData((LivingEntity)sender, GottaMineFastEnchantment.MINING_MULTIPLIER_TAG);
            miningData.set(Float.valueOf(this.value));
        }
    }
}

