/*
 * Decompiled with CFR 0.152.
 */
package com.wonderfulenchantments.enchantments;

import com.mlib.CommonHelper;
import com.mlib.EquipmentSlots;
import com.mlib.config.DoubleConfig;
import com.mlib.config.DurationConfig;
import com.mlib.config.IConfig;
import com.mlib.config.IntegerConfig;
import com.mlib.effects.EffectHelper;
import com.mlib.entities.EntityHelper;
import com.mlib.math.AABBHelper;
import com.mlib.math.VectorHelper;
import com.wonderfulenchantments.Instances;
import com.wonderfulenchantments.RegistryHandler;
import com.wonderfulenchantments.enchantments.WonderfulEnchantment;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class GuardianEnchantment
extends WonderfulEnchantment {
    protected final DoubleConfig redirectMultiplier;
    protected final DoubleConfig minimumHealthRatio;
    protected final DoubleConfig minimumDamageToRedirect;
    protected final DoubleConfig redirectDistance;
    protected final IntegerConfig maximumAmplifier;
    protected final DurationConfig effectDuration;
    protected static final MobEffect RESISTANCE_EFFECT = MobEffects.f_19606_;

    public GuardianEnchantment() {
        super("guardian_angel", Enchantment.Rarity.RARE, RegistryHandler.SHIELD, EquipmentSlots.BOTH_HANDS, "GuardianAngel");
        String redirectComment = "Amount of damage redirected to the player. (in percentage)";
        this.redirectMultiplier = new DoubleConfig("redirect_multiplier", redirectComment, false, 0.25, 0.01, 1.0);
        String ratioComment = "Minimum player's health ratio to redirect damage to the player.";
        this.minimumHealthRatio = new DoubleConfig("minimum_health_ratio", ratioComment, false, 0.5, 0.01, 1.0);
        String damageComment = "Minimum damage required to redirect damage to any entity.";
        this.minimumDamageToRedirect = new DoubleConfig("minimum_damage", damageComment, false, 2.0, 2.0, 100.0);
        String distanceComment = "Maximum distance to the entity to redirect damage.";
        this.redirectDistance = new DoubleConfig("redirect_distance", distanceComment, false, 10.0, 1.0, 100.0);
        String amplifierComment = "Maximum amplifier of 'Resistance' effect.";
        this.maximumAmplifier = new IntegerConfig("maximum_amplifier", amplifierComment, false, 2, 0, 4);
        String durationComment = "Duration of 'Resistance' effect.";
        this.effectDuration = new DurationConfig("effect_duration", durationComment, false, 12.0, 0.0, 600.0);
        this.enchantmentGroup.addConfigs(new IConfig[]{this.redirectMultiplier, this.minimumHealthRatio, this.minimumDamageToRedirect, this.redirectDistance, this.maximumAmplifier, this.effectDuration});
        this.setMaximumEnchantmentLevel(1);
        this.setDifferenceBetweenMinimumAndMaximum(38);
        this.setMinimumEnchantabilityCalculator(level -> 12);
    }

    @SubscribeEvent
    public static void onEntityAttacked(LivingHurtEvent event) {
        LivingEntity target = event.getEntityLiving();
        DamageSource damageSource = event.getSource();
        GuardianEnchantment guardian = Instances.GUARDIAN;
        ServerLevel level = (ServerLevel)CommonHelper.castIfPossible(ServerLevel.class, (Object)target.f_19853_);
        if (level == null) {
            return;
        }
        double redirectMultiplier = guardian.redirectMultiplier.get();
        for (LivingEntity nearbyGuardian : guardian.getNearbyGuardians(level, damageSource, target)) {
            float damage = event.getAmount();
            if ((double)damage < guardian.minimumDamageToRedirect.get()) break;
            if (!guardian.hasEnchantment(target)) {
                nearbyGuardian.m_6469_(damageSource, (float)((double)damage * redirectMultiplier));
                event.setAmount((float)((double)damage * (1.0 - redirectMultiplier)));
            }
            guardian.applyResistance(nearbyGuardian);
            guardian.applyResistance(target);
        }
    }

    protected List<LivingEntity> getNearbyGuardians(ServerLevel level, DamageSource source, LivingEntity target) {
        double maximumRedirectDistance = this.redirectDistance.get();
        AABB axisAligned = AABBHelper.createInflatedAABB((Vec3)target.m_20182_(), (double)maximumRedirectDistance);
        Comparator comparator = (e1, e2) -> e1.m_20270_((Entity)target) < e2.m_20270_((Entity)target) ? -1 : 1;
        List nearbyGuardians = level.m_6443_(LivingEntity.class, axisAligned, this.getGuardianPredicate(source, target));
        nearbyGuardians.sort(comparator);
        return nearbyGuardians;
    }

    protected Predicate<LivingEntity> getGuardianPredicate(DamageSource damageSource, LivingEntity target) {
        Predicate<LivingEntity> distancePredicate = entity -> VectorHelper.distance((Vec3)entity.m_20182_(), (Vec3)target.m_20182_()) <= this.redirectDistance.get();
        Predicate<LivingEntity> friendPredicate = entity -> this.isTargetFriendly(target, (LivingEntity)entity);
        Predicate<LivingEntity> healthPredicate = entity -> EntityHelper.getHealthRatio((LivingEntity)entity) >= this.minimumHealthRatio.get();
        Predicate<LivingEntity> differentPredicate = entity -> !entity.equals((Object)damageSource.m_7639_());
        Predicate<LivingEntity> hasGuardianPredicate = arg_0 -> ((GuardianEnchantment)this).hasEnchantment(arg_0);
        return distancePredicate.and(friendPredicate.and(healthPredicate.and(differentPredicate.and(hasGuardianPredicate))));
    }

    protected boolean isTargetFriendly(LivingEntity target, LivingEntity nearbyEntity) {
        TamableAnimal animal = (TamableAnimal)CommonHelper.castIfPossible(TamableAnimal.class, (Object)target);
        return animal != null && animal.m_142504_() == nearbyEntity.m_142081_() || target instanceof Villager;
    }

    protected void applyResistance(LivingEntity entity) {
        EffectHelper.applyEffectIfPossible((LivingEntity)entity, (MobEffect)RESISTANCE_EFFECT, (int)this.effectDuration.getDuration(), (int)this.getResistanceAmplifier(entity));
    }

    protected int getResistanceAmplifier(LivingEntity entity) {
        MobEffectInstance effectInstance;
        if (entity.m_21023_(RESISTANCE_EFFECT) && (effectInstance = entity.m_21124_(RESISTANCE_EFFECT)) != null) {
            return Math.min(effectInstance.m_19564_() + 1, this.maximumAmplifier.get());
        }
        return 0;
    }
}

