/*
 * Decompiled with CFR 0.152.
 */
package com.wonderfulenchantments.enchantments;

import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfig;
import com.mlib.config.IntegerConfig;
import com.mlib.features.FarmlandTiller;
import com.wonderfulenchantments.Instances;
import com.wonderfulenchantments.enchantments.WonderfulEnchantment;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class HarvesterEnchantment
extends WonderfulEnchantment {
    public final IntegerConfig range;
    public final IntegerConfig durabilityPenalty;
    public final DoubleConfig growChance;
    public final DoubleConfig netherWartGrowChance;

    public HarvesterEnchantment() {
        super("harvester", Enchantment.Rarity.UNCOMMON, EnchantmentCategory.DIGGER, EquipmentSlot.MAINHAND, "Harvester");
        String rangeComment = "Range increase per enchantment level. (per block in x-axis and z-axis)";
        this.range = new IntegerConfig("range", rangeComment, false, 1, 1, 3);
        String durabilityComment = "Penalty for increasing age of nearby crops. (per successful increase)";
        this.durabilityPenalty = new IntegerConfig("durability_penalty", durabilityComment, false, 1, 1, 10);
        String growComment = "Chance for increasing age of nearby crops. (calculated for each crop separately)";
        this.growChance = new DoubleConfig("grow_chance", growComment, false, 0.04, 0.0, 1.0);
        String wartComment = "Chance for increasing age of nearby Nether Warts. (calculated for each crop separately)";
        this.netherWartGrowChance = new DoubleConfig("nether_wart_grow_chance", wartComment, false, 0.01, 0.0, 1.0);
        this.enchantmentGroup.addConfigs(new IConfig[]{this.range, this.durabilityPenalty, this.growChance, this.netherWartGrowChance});
        this.setMaximumEnchantmentLevel(3);
        this.setDifferenceBetweenMinimumAndMaximum(30);
        this.setMinimumEnchantabilityCalculator(level -> 10 * level);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return stack.m_41720_() instanceof HoeItem && super.canApplyAtEnchantingTable(stack);
    }

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        ItemStack itemStack = event.getItemStack();
        Player player = event.getPlayer();
        BlockPos position = event.getPos();
        if (!Instances.HARVESTER.hasEnchantment(itemStack)) {
            return;
        }
        BlockState blockState = player.f_19853_.m_8055_(position);
        Block block = blockState.m_60734_();
        if (block instanceof CropBlock) {
            HarvesterEnchantment.handleCrops((CropBlock)block, player, position, blockState, itemStack);
        } else if (block instanceof NetherWartBlock) {
            HarvesterEnchantment.handleNetherWarts((NetherWartBlock)block, player, position, blockState, itemStack);
        }
    }

    protected static void handleCrops(CropBlock crops, Player player, BlockPos position, BlockState blockState, ItemStack itemStack) {
        if (!crops.m_52307_(blockState)) {
            return;
        }
        crops.m_6240_(player.f_19853_, player, position, blockState, null, itemStack);
        HarvesterEnchantment.playSound(player, position);
    }

    protected static void handleNetherWarts(NetherWartBlock netherWartBlock, Player player, BlockPos position, BlockState blockState, ItemStack itemStack) {
        int netherWartMaximumAge = 3;
        if ((Integer)blockState.m_61143_((Property)NetherWartBlock.f_54967_) < netherWartMaximumAge) {
            return;
        }
        netherWartBlock.m_6240_(player.f_19853_, player, position, blockState, null, itemStack);
        HarvesterEnchantment.playSound(player, position);
    }

    protected static void playSound(Player player, BlockPos position) {
        player.f_19853_.m_5594_(null, position, SoundEvents.f_12019_, SoundSource.AMBIENT, 0.25f, 0.5f);
    }

    static {
        FarmlandTiller.registerList.add(new FarmlandTiller.Register(){

            public boolean shouldBeExecuted(ServerLevel serverLevel, Player player, ItemStack itemStack) {
                HarvesterEnchantment harvester = Instances.HARVESTER;
                return harvester.getEnchantmentLevel(itemStack) >= harvester.m_6586_();
            }
        });
    }
}

