/*
 * Decompiled with CFR 0.152.
 */
package com.wonderfulenchantments.enchantments;

import com.mlib.CommonHelper;
import com.mlib.EquipmentSlots;
import com.mlib.LevelHelper;
import com.wonderfulenchantments.Instances;
import com.wonderfulenchantments.RegistryHandler;
import com.wonderfulenchantments.enchantments.WonderfulEnchantment;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class HorseFrostWalkerEnchantment
extends WonderfulEnchantment {
    public HorseFrostWalkerEnchantment() {
        super("horse_frost_walker", Enchantment.Rarity.RARE, RegistryHandler.HORSE_ARMOR, EquipmentSlots.ARMOR, "HorseFrostWalker");
        this.setMaximumEnchantmentLevel(2);
        this.setDifferenceBetweenMinimumAndMaximum(15);
        this.setMinimumEnchantabilityCalculator(level -> 10 * level);
    }

    public boolean m_6591_() {
        return true;
    }

    @SubscribeEvent
    public static void freezeNearby(LivingEvent.LivingUpdateEvent event) {
        Animal animal = (Animal)CommonHelper.castIfPossible(Animal.class, (Object)event.getEntityLiving());
        if (animal == null || animal.f_19853_.m_5776_()) {
            return;
        }
        int frostLevel = Instances.HORSE_FROST_WALKER.getEnchantmentSum(animal.m_6168_());
        if (frostLevel > 0) {
            LevelHelper.freezeWater((LivingEntity)animal, (double)(2 + frostLevel), (int)60, (int)120);
        }
    }

    @SubscribeEvent
    public static void onTakingDamage(LivingDamageEvent event) {
        if (event.getSource() != DamageSource.f_19309_) {
            return;
        }
        Animal animal = (Animal)CommonHelper.castIfPossible(Animal.class, (Object)event.getEntityLiving());
        if (animal != null && Instances.HORSE_FROST_WALKER.getEnchantmentSum(animal.m_6168_()) > 0) {
            event.setCanceled(true);
        }
    }
}

