/*
 * Decompiled with CFR 0.152.
 */
package com.wonderfulenchantments.enchantments;

import com.mlib.EquipmentSlots;
import com.mlib.attributes.AttributeHandler;
import com.mlib.config.IConfig;
import com.mlib.config.IntegerConfig;
import com.mlib.enchantments.EnchantmentHelperPlus;
import com.wonderfulenchantments.Instances;
import com.wonderfulenchantments.RegistryHandler;
import com.wonderfulenchantments.enchantments.WonderfulEnchantment;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.HorseArmorItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class HorseProtectionEnchantment
extends WonderfulEnchantment {
    private static final AttributeHandler ATTRIBUTE_HANDLER = new AttributeHandler("f7f6f46b-23a1-4d3b-8e83-3160c6390f9a", "HorseProtectionBonus", Attributes.f_22284_, AttributeModifier.Operation.ADDITION);
    protected final IntegerConfig armorBonus;

    public HorseProtectionEnchantment() {
        super("horse_protection", Enchantment.Rarity.UNCOMMON, RegistryHandler.HORSE_ARMOR, EquipmentSlots.ARMOR, "HorseProtection");
        String comment = "Horse armor bonus per enchantment level.";
        this.armorBonus = new IntegerConfig("armor_bonus", comment, false, 2, 1, 10);
        this.enchantmentGroup.addConfig((IConfig)this.armorBonus);
        this.setMaximumEnchantmentLevel(4);
        this.setDifferenceBetweenMinimumAndMaximum(10);
        this.setMinimumEnchantabilityCalculator(level -> 1 + 6 * (level - 1));
    }

    @SubscribeEvent
    public static void onEquipmentChange(LivingEquipmentChangeEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (entity instanceof Animal) {
            ATTRIBUTE_HANDLER.setValueAndApply(entity, HorseProtectionEnchantment.getArmorBonus((Animal)entity));
        }
    }

    protected static double getArmorBonus(Animal animal) {
        int protectionLevel = EnchantmentHelperPlus.calculateEnchantmentSumIfIsInstanceOf((Enchantment)Instances.HORSE_PROTECTION, (Iterable)animal.m_6168_(), HorseArmorItem.class);
        return protectionLevel * Instances.HORSE_PROTECTION.armorBonus.get();
    }
}

