/*
 * Decompiled with CFR 0.152.
 */
package com.wonderfulenchantments.enchantments;

import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfig;
import com.mlib.damage.DamageHelper;
import com.mlib.entities.EntityHelper;
import com.wonderfulenchantments.Instances;
import com.wonderfulenchantments.enchantments.WonderfulEnchantment;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.DamageEnchantment;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class HumanSlayerEnchantment
extends WonderfulEnchantment {
    protected final DoubleConfig damageBonus;

    public HumanSlayerEnchantment() {
        super("human_slayer", Enchantment.Rarity.UNCOMMON, EnchantmentCategory.WEAPON, EquipmentSlot.MAINHAND, "AgainstHumanity");
        String comment = "Damage bonus per enchantment level.";
        this.damageBonus = new DoubleConfig("damage_bonus", comment, false, 2.5, 1.0, 10.0);
        this.enchantmentGroup.addConfig((IConfig)this.damageBonus);
        this.setMaximumEnchantmentLevel(5);
        this.setDifferenceBetweenMinimumAndMaximum(20);
        this.setMinimumEnchantabilityCalculator(level -> 5 + (level - 1) * 8);
    }

    public boolean m_6081_(ItemStack stack) {
        return stack.m_41720_() instanceof AxeItem || super.m_6081_(stack);
    }

    protected boolean m_5975_(Enchantment enchantment) {
        return !(enchantment instanceof DamageEnchantment) && super.m_5975_(enchantment);
    }

    @SubscribeEvent
    public static void onEntityHurt(LivingHurtEvent event) {
        DamageSource damageSource = event.getSource();
        if (!DamageHelper.areEntitiesInstancesOf((DamageSource)damageSource, LivingEntity.class, LivingEntity.class)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)damageSource.m_7640_();
        LivingEntity target = event.getEntityLiving();
        HumanSlayerEnchantment humanSlayer = Instances.HUMAN_SLAYER;
        float extraDamage = (float)Math.floor(humanSlayer.damageBonus.get() * (double)humanSlayer.getEnchantmentLevel(attacker));
        if (extraDamage > 0.0f && EntityHelper.isHuman((Entity)target)) {
            ((ServerLevel)attacker.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123808_, target.m_20185_(), target.m_20227_(0.625), target.m_20189_(), 24, 0.125, 0.25, 0.125, 0.5);
            event.setAmount(event.getAmount() + extraDamage);
        }
    }
}

