/*
 * Decompiled with CFR 0.152.
 */
package com.wonderfulenchantments.enchantments;

import com.mlib.CommonHelper;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfig;
import com.mlib.math.VectorHelper;
import com.wonderfulenchantments.Instances;
import com.wonderfulenchantments.RegistryHandler;
import com.wonderfulenchantments.enchantments.WonderfulEnchantment;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class HunterEnchantment
extends WonderfulEnchantment {
    protected final DoubleConfig damageMultiplier;
    protected final DoubleConfig minimumDistance;
    protected final DoubleConfig damagePenaltyMultiplier;

    public HunterEnchantment() {
        super("hunter", Enchantment.Rarity.RARE, RegistryHandler.BOW_AND_CROSSBOW, EquipmentSlot.MAINHAND, "Hunter");
        String damageComment = "Extra damage multiplier to distance per enchantment level.";
        this.damageMultiplier = new DoubleConfig("damage_multiplier", damageComment, false, 1.0E-4, 0.0, 0.01);
        String distanceComment = "Minimum required distance to not get any damage penalty.";
        this.minimumDistance = new DoubleConfig("minimum_distance", distanceComment, false, 80.0, 1.0, 10000.0);
        String penaltyComment = "Maximum damage penalty if a mob is very close.";
        this.damagePenaltyMultiplier = new DoubleConfig("penalty_multiplier", penaltyComment, false, 0.5, 0.0, 1.0);
        this.enchantmentGroup.addConfigs(new IConfig[]{this.damageMultiplier, this.minimumDistance, this.damagePenaltyMultiplier});
        this.setMaximumEnchantmentLevel(3);
        this.setDifferenceBetweenMinimumAndMaximum(50);
        this.setMinimumEnchantabilityCalculator(level -> 15 + (level - 1) * 9);
    }

    @SubscribeEvent
    public static void spawnExtraLoot(LootingLevelEvent event) {
        DamageSource damageSource = event.getDamageSource();
        if (damageSource == null) {
            return;
        }
        LivingEntity entity = (LivingEntity)CommonHelper.castIfPossible(LivingEntity.class, (Object)damageSource.m_7639_());
        if (HunterEnchantment.isValid(damageSource) && entity != null) {
            event.setLootingLevel(event.getLootingLevel() + Instances.HUNTER.getEnchantmentLevel(entity.m_21205_()));
        }
    }

    @SubscribeEvent
    public static void onHit(LivingHurtEvent event) {
        DamageSource damageSource = event.getSource();
        LivingEntity target = event.getEntityLiving();
        LivingEntity attacker = (LivingEntity)CommonHelper.castIfPossible(LivingEntity.class, (Object)damageSource.m_7639_());
        HunterEnchantment hunter = Instances.HUNTER;
        if (HunterEnchantment.isValid(damageSource) && attacker != null && hunter.hasEnchantment(attacker.m_21205_())) {
            event.setAmount((float)((double)event.getAmount() * hunter.getDamageMultiplier(attacker, target)));
        }
    }

    protected static boolean isValid(DamageSource source) {
        return source != null && source.m_7640_() instanceof Arrow && source.m_7639_() instanceof LivingEntity;
    }

    protected double getDamageMultiplier(LivingEntity attacker, LivingEntity target) {
        int hunterLevel = this.getEnchantmentLevel(attacker.m_21205_());
        double distance = VectorHelper.distanceSquared((Vec3)attacker.m_20182_(), (Vec3)target.m_20182_());
        double penaltyMultiplier = Math.max(1.0 - distance / this.minimumDistance.get(), 0.0) * this.damagePenaltyMultiplier.get();
        return distance * this.damageMultiplier.get() * (double)hunterLevel + 1.0 - penaltyMultiplier;
    }
}

