/*
 * Decompiled with CFR 0.152.
 */
package com.wonderfulenchantments.enchantments;

import com.mlib.EquipmentSlots;
import com.wonderfulenchantments.Instances;
import com.wonderfulenchantments.RegistryHandler;
import com.wonderfulenchantments.enchantments.WonderfulEnchantment;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ImmortalityEnchantment
extends WonderfulEnchantment {
    protected static final int DAMAGE_ON_USE = 9001;

    public ImmortalityEnchantment() {
        super("immortality", Enchantment.Rarity.RARE, RegistryHandler.SHIELD, EquipmentSlots.BOTH_HANDS, "Immortality");
        this.setMaximumEnchantmentLevel(1);
        this.setDifferenceBetweenMinimumAndMaximum(30);
        this.setMinimumEnchantabilityCalculator(level -> 20);
    }

    @SubscribeEvent
    public static void onEntityHurt(LivingDamageEvent event) {
        LivingEntity target = event.getEntityLiving();
        if (target.m_21223_() - event.getAmount() < 1.0f) {
            if (ImmortalityEnchantment.tryCheatDeath(target, EquipmentSlot.MAINHAND)) {
                event.setCanceled(true);
            } else if (ImmortalityEnchantment.tryCheatDeath(target, EquipmentSlot.OFFHAND)) {
                event.setCanceled(true);
            }
        }
    }

    protected static boolean tryCheatDeath(LivingEntity target, EquipmentSlot equipmentSlot) {
        ItemStack itemStack = target.m_6844_(equipmentSlot);
        if (itemStack.m_41720_() instanceof ShieldItem && Instances.IMMORTALITY.hasEnchantment(itemStack)) {
            target.m_21153_(target.m_21233_());
            ImmortalityEnchantment.spawnParticlesAndPlaySounds(target);
            itemStack.m_41622_(9001, target, entity -> entity.m_21166_(equipmentSlot));
            return true;
        }
        return false;
    }

    protected static void spawnParticlesAndPlaySounds(LivingEntity livingEntity) {
        ServerLevel world = (ServerLevel)livingEntity.f_19853_;
        world.m_8767_((ParticleOptions)ParticleTypes.f_123767_, livingEntity.m_20185_(), livingEntity.m_20227_(0.75), livingEntity.m_20189_(), 64, 0.25, 0.5, 0.25, 0.5);
        world.m_6263_(null, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), SoundEvents.f_12513_, SoundSource.AMBIENT, 1.0f, 1.0f);
    }
}

