/*
 * Decompiled with CFR 0.152.
 */
package com.wonderfulenchantments.enchantments;

import com.mlib.CommonHelper;
import com.mlib.Random;
import com.mlib.config.DoubleConfig;
import com.mlib.config.DurationConfig;
import com.mlib.config.IConfig;
import com.mlib.effects.EffectHelper;
import com.mlib.math.VectorHelper;
import com.wonderfulenchantments.Instances;
import com.wonderfulenchantments.enchantments.WonderfulEnchantment;
import java.util.Collection;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class LeechEnchantment
extends WonderfulEnchantment {
    protected final DoubleConfig leechChance;
    protected final DurationConfig maximumDuration;

    public LeechEnchantment() {
        super("leech", Enchantment.Rarity.UNCOMMON, EnchantmentCategory.WEAPON, EquipmentSlot.MAINHAND, "Leech");
        String chanceComment = "Chance for stealing positive effect/health from enemy.";
        this.leechChance = new DoubleConfig("leech_chance", chanceComment, false, 0.25, 0.0, 1.0);
        String durationComment = "Maximum duration in seconds that effect can have.";
        this.maximumDuration = new DurationConfig("maximum_duration", durationComment, false, 120.0, 0.1, 600.0);
        this.enchantmentGroup.addConfigs(new IConfig[]{this.leechChance, this.maximumDuration});
        this.setMaximumEnchantmentLevel(1);
        this.setDifferenceBetweenMinimumAndMaximum(20);
        this.setMinimumEnchantabilityCalculator(level -> level * 20);
    }

    public boolean m_6081_(ItemStack stack) {
        return stack.m_41720_() instanceof AxeItem || super.m_6081_(stack);
    }

    @SubscribeEvent
    public static void onHit(LivingAttackEvent event) {
        LeechEnchantment leech = Instances.LEECH;
        if (!Random.tryChance((double)leech.leechChance.get())) {
            return;
        }
        DamageSource damageSource = event.getSource();
        LivingEntity attacker = (LivingEntity)CommonHelper.castIfPossible(LivingEntity.class, (Object)damageSource.m_7640_());
        LivingEntity target = event.getEntityLiving();
        if (attacker == null) {
            return;
        }
        if (leech.hasEnchantment(attacker)) {
            int vampirismLevel = leech.getEnchantmentSum(attacker.m_6168_());
            for (int i = 0; i < 1 + vampirismLevel; ++i) {
                leech.steal(attacker, target);
            }
            LeechEnchantment.spawnParticlesAndPlaySounds(attacker, target);
        }
    }

    protected static void spawnParticlesAndPlaySounds(LivingEntity attacker, LivingEntity target) {
        ServerLevel world = (ServerLevel)CommonHelper.castIfPossible(ServerLevel.class, (Object)attacker.f_19853_);
        if (world == null) {
            return;
        }
        Vec3 startPosition = VectorHelper.add((Vec3)attacker.m_20182_(), (Vec3)new Vec3(0.0, (double)attacker.m_20206_() * 0.75, 0.0));
        Vec3 endPosition = VectorHelper.add((Vec3)target.m_20182_(), (Vec3)new Vec3(0.0, (double)target.m_20206_() * 0.75, 0.0));
        Vec3 difference = VectorHelper.subtract((Vec3)endPosition, (Vec3)startPosition);
        int amountOfParticles = (int)Math.ceil(startPosition.m_82554_(endPosition) * 5.0);
        for (int i = 0; i <= amountOfParticles; ++i) {
            Vec3 step = VectorHelper.multiply((Vec3)difference, (Number)Float.valueOf((float)i / (float)amountOfParticles));
            Vec3 currentPosition = VectorHelper.add((Vec3)startPosition, (Vec3)step);
            world.m_8767_((ParticleOptions)ParticleTypes.f_123808_, currentPosition.f_82479_, currentPosition.f_82480_, currentPosition.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
        }
        world.m_6263_(null, startPosition.f_82479_, startPosition.f_82480_, startPosition.f_82481_, SoundEvents.f_11911_, SoundSource.AMBIENT, 0.25f, 1.0f);
    }

    protected void steal(LivingEntity stealer, LivingEntity target) {
        Collection targetEffects = target.m_21220_();
        if (targetEffects.size() <= 0 || !this.stealEffect(stealer, target, targetEffects)) {
            this.stealHealth(stealer, target);
        }
    }

    protected boolean stealEffect(LivingEntity stealer, LivingEntity target, Collection<MobEffectInstance> effects) {
        MobEffectInstance[] possibleEffects;
        for (MobEffectInstance effectInstance : possibleEffects = effects.toArray(new MobEffectInstance[0])) {
            MobEffect effect = effectInstance.m_19544_();
            if (!effect.m_19486_()) continue;
            int maximumDurationInTicks = Math.min(effectInstance.m_19557_(), this.maximumDuration.getDuration());
            EffectHelper.applyEffectIfPossible((LivingEntity)stealer, (MobEffect)effect, (int)maximumDurationInTicks, (int)effectInstance.m_19564_());
            target.m_21195_(effect);
            return true;
        }
        return false;
    }

    protected void stealHealth(LivingEntity stealer, LivingEntity target) {
        target.m_6469_(DamageSource.f_19319_, 1.0f);
        stealer.m_5634_(1.0f);
    }
}

