/*
 * Decompiled with CFR 0.152.
 */
package com.wonderfulenchantments.enchantments;

import com.mlib.EquipmentSlots;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfig;
import com.wonderfulenchantments.enchantments.WonderfulEnchantment;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;

public class MagicProtectionEnchantment
extends WonderfulEnchantment {
    protected final DoubleConfig protectionBonus;

    public MagicProtectionEnchantment() {
        super("magic_protection", Enchantment.Rarity.UNCOMMON, EnchantmentCategory.ARMOR, EquipmentSlots.ARMOR, "MagicProtection");
        String comment = "Damage reduction bonus per enchantment level.";
        this.protectionBonus = new DoubleConfig("armor_bonus", comment, false, 2.0, 1.0, 10.0);
        this.enchantmentGroup.addConfig((IConfig)this.protectionBonus);
        this.setMaximumEnchantmentLevel(4);
        this.setDifferenceBetweenMinimumAndMaximum(11);
        this.setMinimumEnchantabilityCalculator(level -> 1 + (level - 1) * 11);
    }

    public int m_7205_(int level, DamageSource source) {
        if (source.m_19390_()) {
            return 0;
        }
        if (source.m_19387_()) {
            return (int)((double)level * this.protectionBonus.get());
        }
        return 0;
    }

    protected boolean m_5975_(Enchantment enchantment) {
        return !(enchantment instanceof ProtectionEnchantment) && super.m_5975_(enchantment);
    }
}

