/*
 * Decompiled with CFR 0.152.
 */
package com.wonderfulenchantments.enchantments;

import com.mlib.Random;
import com.mlib.config.ConfigGroup;
import com.mlib.config.DoubleConfig;
import com.mlib.config.DurationConfig;
import com.mlib.config.IConfig;
import com.mlib.config.StringListConfig;
import com.mlib.effects.EffectHelper;
import com.wonderfulenchantments.Instances;
import com.wonderfulenchantments.enchantments.WonderfulEnchantment;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class MithridatismEnchantment
extends WonderfulEnchantment {
    public MithridatismEnchantment() {
        super("mithridatism", Enchantment.Rarity.VERY_RARE, EnchantmentCategory.ARMOR_CHEST, EquipmentSlot.CHEST, "Mithridatism");
        this.setMaximumEnchantmentLevel(4);
        this.setDifferenceBetweenMinimumAndMaximum(30);
        this.setMinimumEnchantabilityCalculator(level -> 15 + 100 * (level - 1));
    }

    public void addConfigGroup(ConfigGroup group) {
        this.enchantmentGroup.addGroup((IConfig)group);
    }

    public int getItemEnchantmentLevel(LivingEntity entity) {
        return this.getEnchantmentLevel(entity.m_6844_(EquipmentSlot.CHEST));
    }

    @Mod.EventBusSubscriber
    public static class MithridatismProtectionEffect
    extends MobEffect {
        protected final ConfigGroup effectGroup;
        protected final StringListConfig damageSourceList;
        protected final DoubleConfig absorptionPerLevel;
        protected final DoubleConfig baseDamageReduction;
        protected final DoubleConfig damageReductionPerLevel;
        protected final DoubleConfig levelUpChance;
        protected final DurationConfig duration;

        public MithridatismProtectionEffect(MithridatismEnchantment mithridatism) {
            super(MobEffectCategory.BENEFICIAL, -8987828);
            String listComment = "Damage sources that deal less damage when the effect is active.";
            this.damageSourceList = new StringListConfig("damage_source_list", listComment, false, new String[]{"magic", "wither", "bleeding"});
            String absorptionComment = "Level of Absorption applied to the player per enchantment level rounded down. (minimum. 1lvl)";
            this.absorptionPerLevel = new DoubleConfig("absorption_per_level", absorptionComment, false, 0.5, 0.0, 3.0);
            String baseReductionComment = "Base amount of damage decreased from negative effects.";
            this.baseDamageReduction = new DoubleConfig("base_reduction", baseReductionComment, false, 0.2, 0.0, 1.0);
            String levelReductionComment = "Amount of damage decreased from negative effects per enchantment level.";
            this.damageReductionPerLevel = new DoubleConfig("reduction_per_level", levelReductionComment, false, 0.1, 0.0, 1.0);
            String durationComment = "Duration of both the Absorption and Mithridatism Protection. (in seconds)";
            this.duration = new DurationConfig("duration", durationComment, false, 60.0, 2.0, 600.0);
            String levelUpComment = "Chance for Mithridatism to increase its level.";
            this.levelUpChance = new DoubleConfig("level_up_chance", levelUpComment, false, 0.025, 0.0, 1.0);
            this.effectGroup = new ConfigGroup("MithridatismProtection", "");
            this.effectGroup.addConfigs(new IConfig[]{this.damageSourceList, this.absorptionPerLevel, this.baseDamageReduction, this.damageReductionPerLevel, this.levelUpChance, this.duration});
            mithridatism.addConfigGroup(this.effectGroup);
        }

        @SubscribeEvent
        public static void whenEffectApplied(PotionEvent.PotionAddedEvent event) {
            MobEffectInstance effectInstance = event.getPotionEffect();
            MobEffect effect = effectInstance.m_19544_();
            LivingEntity entity = event.getEntityLiving();
            MithridatismEnchantment mithridatism = Instances.MITHRIDATISM;
            MithridatismProtectionEffect mithridatismEffect = Instances.MITHRIDATISM_PROTECTION;
            int mithridatismLevel = mithridatism.getItemEnchantmentLevel(entity);
            if (!effect.m_19486_() && mithridatismLevel > 0 && !entity.m_21023_((MobEffect)mithridatismEffect)) {
                int duration = mithridatismEffect.getDuration();
                EffectHelper.applyEffectIfPossible((LivingEntity)entity, (MobEffect)mithridatismEffect, (int)duration, (int)(mithridatismLevel - 1));
                int absorptionAmplifier = Math.max(0, mithridatismEffect.getAbsorptionLevel(entity) - 1);
                EffectHelper.applyEffectIfPossible((LivingEntity)entity, (MobEffect)MobEffects.f_19617_, (int)duration, (int)absorptionAmplifier);
            }
        }

        @SubscribeEvent
        public static void whenEffectRemoved(PotionEvent.PotionExpiryEvent event) {
            MobEffectInstance effectInstance = event.getPotionEffect();
            if (effectInstance == null) {
                return;
            }
            MobEffect effect = effectInstance.m_19544_();
            LivingEntity entity = event.getEntityLiving();
            MithridatismEnchantment mithridatism = Instances.MITHRIDATISM;
            MithridatismProtectionEffect mithridatismEffect = Instances.MITHRIDATISM_PROTECTION;
            int mithridatismLevel = mithridatism.getItemEnchantmentLevel(entity);
            if (mithridatismLevel >= mithridatism.m_6586_() || mithridatismLevel == 0 || mithridatism.isDisabled()) {
                return;
            }
            if (effect.m_19486_() || !Random.tryChance((double)mithridatismEffect.levelUpChance.get())) {
                return;
            }
            mithridatismEffect.increaseLevel(entity);
        }

        @SubscribeEvent
        public static void whenDamaged(LivingHurtEvent event) {
            MithridatismProtectionEffect mithridatismEffect = Instances.MITHRIDATISM_PROTECTION;
            DamageSource damageSource = event.getSource();
            if (!mithridatismEffect.isDamageAffected(damageSource)) {
                return;
            }
            double damageReduction = mithridatismEffect.getDamageReduction(event.getEntityLiving());
            if (damageReduction == 0.0) {
                return;
            }
            event.setAmount((float)((double)event.getAmount() * (1.0 - damageReduction)));
        }

        protected double getDamageReduction(LivingEntity entity) {
            MobEffectInstance effectInstance = entity.m_21124_((MobEffect)this);
            int mithridatismLevel = effectInstance != null ? effectInstance.m_19564_() : 0;
            return mithridatismLevel == 0 ? 0.0 : Math.min(1.0, (double)mithridatismLevel * this.damageReductionPerLevel.get() + this.baseDamageReduction.get());
        }

        protected int getAbsorptionLevel(LivingEntity entity) {
            int mithridatismLevel = Instances.MITHRIDATISM.getItemEnchantmentLevel(entity);
            return mithridatismLevel == 0 ? 0 : (int)Math.max(0.0, (double)mithridatismLevel * this.absorptionPerLevel.get());
        }

        protected int getDuration() {
            return this.duration.getDuration();
        }

        protected boolean isDamageAffected(DamageSource damageSource) {
            return this.damageSourceList.contains(damageSource.m_19385_());
        }

        protected void increaseLevel(LivingEntity entity) {
            ItemStack chestplate = entity.m_6844_(EquipmentSlot.CHEST);
            Instances.MITHRIDATISM.increaseEnchantmentLevel(chestplate);
            this.notifyAboutLevelUp(entity);
        }

        protected void notifyAboutLevelUp(LivingEntity entity) {
            if (!(entity instanceof Player)) {
                return;
            }
            TranslatableComponent message = new TranslatableComponent("wonderful_enchantments.mithridatism_level_up");
            message.m_130940_(ChatFormatting.BOLD);
            Player player = (Player)entity;
            player.m_5661_((Component)message, true);
        }
    }
}

