/*
 * Decompiled with CFR 0.152.
 */
package com.wonderfulenchantments.enchantments;

import com.mlib.attributes.AttributeHandler;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfig;
import com.mlib.config.IntegerConfig;
import com.mlib.time.TimeHelper;
import com.wonderfulenchantments.Instances;
import com.wonderfulenchantments.RegistryHandler;
import com.wonderfulenchantments.enchantments.WonderfulEnchantment;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.FrostWalkerEnchantment;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class PhoenixDiveEnchantment
extends WonderfulEnchantment {
    protected final DoubleConfig jumpMultiplier;
    protected final DoubleConfig damageDistance;
    protected final IntegerConfig jumpPenalty;
    protected final IntegerConfig secondsOnFire;

    public PhoenixDiveEnchantment() {
        super("phoenix_dive", Enchantment.Rarity.RARE, EnchantmentCategory.ARMOR_FEET, EquipmentSlot.FEET, "PheonixDive");
        String jumpComment = "Jumping power multiplier per enchantment level.";
        this.jumpMultiplier = new DoubleConfig("jump_multiplier", jumpComment, false, 0.3, 0.01, 1.0);
        String distanceComment = "Area of entities that will take damage. (area of square where A = (x - value, z - value) and B = (x + value, z + value))";
        this.damageDistance = new DoubleConfig("damage_range", distanceComment, false, 5.0, 1.0, 100.0);
        String penaltyComment = "Penalty for using special jump. (damage to durability)";
        this.jumpPenalty = new IntegerConfig("jump_penalty", penaltyComment, false, 3, 0, 100);
        String fireComment = "Duration of igniting nearby opponents per enchantment level. (in seconds)";
        this.secondsOnFire = new IntegerConfig("jump_penalty", fireComment, false, 3, 1, 100);
        this.enchantmentGroup.addConfigs(new IConfig[]{this.jumpMultiplier, this.jumpPenalty, this.damageDistance, this.secondsOnFire});
        this.setMaximumEnchantmentLevel(3);
        this.setDifferenceBetweenMinimumAndMaximum(30);
        this.setMinimumEnchantabilityCalculator(level -> 10 * (level + 1));
    }

    public boolean m_5975_(Enchantment enchantment) {
        return !(enchantment instanceof FrostWalkerEnchantment) && super.m_5975_(enchantment);
    }

    @SubscribeEvent
    public static void onFall(LivingFallEvent event) {
        if ((double)event.getDistance() <= 3.0) {
            return;
        }
        LivingEntity attacker = event.getEntityLiving();
        int enchantmentLevel = PhoenixDiveEnchantment.getPhoenixDiveLevel(attacker);
        if (enchantmentLevel <= 0 || !(attacker.f_19853_ instanceof ServerLevel)) {
            return;
        }
        ServerLevel world = (ServerLevel)attacker.f_19853_;
        for (Entity entity : PhoenixDiveEnchantment.getEntitiesInRange(attacker, world)) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity target = (LivingEntity)entity;
            target.m_20254_(Instances.PHOENIX_DIVE.secondsOnFire.get() * enchantmentLevel);
            target.m_6469_(DamageSource.m_19373_((LivingEntity)attacker), 0.0f);
            target.m_6469_(DamageSource.f_19307_, (float)Math.sqrt((float)enchantmentLevel * event.getDistance()));
        }
        PhoenixDiveEnchantment.spawnFallParticles(attacker.m_20182_(), world);
    }

    @SubscribeEvent
    public static void onUpdate(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        CompoundTag data = player.getPersistentData();
        if (PhoenixDiveEnchantment.getPhoenixDiveLevel((LivingEntity)player) <= 0 || !(player.f_19853_ instanceof ServerLevel) || !TimeHelper.isEndPhase((TickEvent)event)) {
            return;
        }
        if (TimeHelper.hasServerTicksPassed((int)3)) {
            PhoenixDiveEnchantment.spawnFootParticle((LivingEntity)player, (ServerLevel)player.f_19853_, TimeHelper.hasServerTicksPassed((int)6));
        }
    }

    @SubscribeEvent
    public static void onJump(LivingEvent.LivingJumpEvent event) {
        if (!(event.getEntityLiving() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntityLiving();
        ItemStack boots = player.m_6844_(EquipmentSlot.FEET);
        int enchantmentLevel = PhoenixDiveEnchantment.getPhoenixDiveLevel((LivingEntity)player);
        if (!player.m_6047_() || enchantmentLevel <= 0) {
            return;
        }
        double angleInRadians = Math.toRadians((double)player.f_19859_ + 90.0);
        double factor = (double)(enchantmentLevel + 1) * Instances.PHOENIX_DIVE.jumpMultiplier.get();
        player.m_20256_(player.m_20184_().m_82559_(new Vec3(0.0, 1.0 + factor, 0.0)).m_82520_(factor * Math.cos(angleInRadians), 0.0, factor * Math.sin(angleInRadians)));
        int damagePenalty = Instances.PHOENIX_DIVE.jumpPenalty.get();
        if (damagePenalty > 0) {
            boots.m_41622_(damagePenalty, (LivingEntity)player, entity -> entity.m_21166_(EquipmentSlot.FEET));
        }
        if (!(player.f_19853_ instanceof ServerLevel)) {
            return;
        }
        ServerLevel world = (ServerLevel)player.f_19853_;
        world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11874_, SoundSource.AMBIENT, 0.5f, 0.9f);
    }

    protected static int getPhoenixDiveLevel(LivingEntity entity) {
        return EnchantmentHelper.m_44843_((Enchantment)Instances.PHOENIX_DIVE, (ItemStack)entity.m_6844_(EquipmentSlot.FEET));
    }

    protected static List<Entity> getEntitiesInRange(LivingEntity livingEntity, ServerLevel world) {
        double range = Instances.PHOENIX_DIVE.damageDistance.get();
        List entities = world.m_45933_((Entity)livingEntity, livingEntity.m_142469_().m_82377_(range, (double)livingEntity.m_20206_(), range));
        return entities.stream().filter(PhoenixDiveEnchantment.getEntitiesPredicate(livingEntity)).toList();
    }

    protected static Predicate<Entity> getEntitiesPredicate(LivingEntity livingEntity) {
        return entity -> {
            boolean canAttack = entity instanceof LivingEntity && AttributeHandler.hasAttribute((LivingEntity)((LivingEntity)entity), (Attribute)Attributes.f_22281_);
            boolean isTamedByEntity = entity instanceof TamableAnimal && ((TamableAnimal)entity).m_21830_(livingEntity);
            boolean isTargetedByEntity = livingEntity.m_142581_() != null && livingEntity.m_142581_().m_7306_(entity);
            boolean wasAttackedByEntity = livingEntity.m_21214_() != null && livingEntity.m_21214_().m_7306_(entity);
            return canAttack && !isTamedByEntity || isTargetedByEntity || wasAttackedByEntity;
        };
    }

    protected static void spawnFallParticles(Vec3 position, ServerLevel world) {
        double x = position.f_82479_;
        double y = position.f_82480_;
        double z = position.f_82481_;
        for (double d = 0.0; d < 3.0; d += 1.0) {
            world.m_8767_((ParticleOptions)((SimpleParticleType)RegistryHandler.PHOENIX_PARTICLE.get()), x, y, z, (int)Math.pow(5.0, d + 1.0), 0.0625, 0.125, 0.0625, 0.1875 * (d + 1.0));
        }
        world.m_6263_(null, x, y, z, SoundEvents.f_11874_, SoundSource.AMBIENT, 0.5f, 0.9f);
    }

    protected static void spawnFootParticle(LivingEntity entity, ServerLevel world, boolean isLeftLeg) {
        if (entity.m_21255_()) {
            return;
        }
        double leftLegRotation = isLeftLeg ? 180.0 : 0.0;
        double angleInRadians = Math.toRadians((double)entity.f_20883_ + 90.0 + leftLegRotation);
        world.m_8767_((ParticleOptions)ParticleTypes.f_123744_, entity.m_20185_() + 0.1875 * Math.sin(-angleInRadians), entity.m_20186_() + 0.1, entity.m_20189_() + 0.1875 * Math.cos(-angleInRadians), 1, 0.0, 0.125 * Math.cos(angleInRadians), 0.0, 0.0);
    }
}

