/*
 * Decompiled with CFR 0.152.
 */
package com.wonderfulenchantments.enchantments;

import com.mlib.CommonHelper;
import com.mlib.TimeConverter;
import com.mlib.config.DurationConfig;
import com.mlib.config.IConfig;
import com.mlib.config.IntegerConfig;
import com.mlib.effects.EffectHelper;
import com.wonderfulenchantments.Instances;
import com.wonderfulenchantments.enchantments.WonderfulEnchantment;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class PufferfishVengeanceEnchantment
extends WonderfulEnchantment {
    protected final DurationConfig durationConfig;
    protected final IntegerConfig hungerAmplifier;
    protected final IntegerConfig poisonAmplifier;
    protected final IntegerConfig nauseaAmplifier;

    public PufferfishVengeanceEnchantment() {
        super("pufferfish_vengeance", Enchantment.Rarity.RARE, EnchantmentCategory.WEAPON, EquipmentSlot.MAINHAND, "PufferfishVengeance");
        String durationComment = "Pufferfish negative effects duration per enchantment level. (in seconds)";
        this.durationConfig = new DurationConfig("duration", durationComment, false, 4.0, 1.0, 30.0);
        String hungerComment = "Amplifier level of Hunger effect.";
        this.hungerAmplifier = new IntegerConfig("hunger", hungerComment, false, 2, 0, 10);
        String poisonComment = "Amplifier level of Poison effect.";
        this.poisonAmplifier = new IntegerConfig("poison", poisonComment, false, 3, 0, 10);
        String nauseaComment = "Amplifier level of Nausea effect.";
        this.nauseaAmplifier = new IntegerConfig("nausea", nauseaComment, false, 0, 0, 10);
        this.enchantmentGroup.addConfigs(new IConfig[]{this.durationConfig, this.hungerAmplifier, this.poisonAmplifier, this.nauseaAmplifier});
        this.setMaximumEnchantmentLevel(2);
        this.setDifferenceBetweenMinimumAndMaximum(20);
        this.setMinimumEnchantabilityCalculator(level -> 5 + level * 12);
    }

    public boolean m_6081_(ItemStack stack) {
        return stack.m_41720_() instanceof AxeItem || super.m_6081_(stack);
    }

    @SubscribeEvent
    public static void onHit(LivingAttackEvent event) {
        PufferfishVengeanceEnchantment pufferfishVengeance = Instances.PUFFERFISH_VENGEANCE;
        DamageSource damageSource = event.getSource();
        LivingEntity attacker = (LivingEntity)CommonHelper.castIfPossible(LivingEntity.class, (Object)damageSource.m_7640_());
        if (attacker == null || !pufferfishVengeance.hasEnchantment(attacker)) {
            return;
        }
        LivingEntity target = event.getEntityLiving();
        pufferfishVengeance.applyEffects(target);
        attacker.f_19853_.m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_12290_, SoundSource.AMBIENT, 1.0f, 1.0f);
    }

    protected void applyEffects(LivingEntity target) {
        int durationInTicks = this.durationConfig.getDuration() + TimeConverter.secondsToTicks((double)1.0);
        EffectHelper.applyEffectIfPossible((LivingEntity)target, (MobEffect)MobEffects.f_19612_, (int)durationInTicks, (int)this.hungerAmplifier.get());
        EffectHelper.applyEffectIfPossible((LivingEntity)target, (MobEffect)MobEffects.f_19614_, (int)durationInTicks, (int)this.poisonAmplifier.get());
        EffectHelper.applyEffectIfPossible((LivingEntity)target, (MobEffect)MobEffects.f_19604_, (int)durationInTicks, (int)this.nauseaAmplifier.get());
    }
}

