/*
 * Decompiled with CFR 0.152.
 */
package com.wonderfulenchantments.enchantments;

import com.mlib.config.DoubleConfig;
import com.mlib.config.DurationConfig;
import com.mlib.config.IConfig;
import com.mlib.math.AABBHelper;
import com.mlib.math.VectorHelper;
import com.mlib.nbt.NBTHelper;
import com.mlib.network.message.BooleanMessage;
import com.mlib.time.TimeHelper;
import com.wonderfulenchantments.Instances;
import com.wonderfulenchantments.PacketHandler;
import com.wonderfulenchantments.enchantments.WonderfulEnchantment;
import java.util.function.Predicate;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber
public class SixthSenseEnchantment
extends WonderfulEnchantment {
    private static final String SENSE_TAG = "SixthSenseCounter";
    private static final String ENEMY_TAG = "SixthSenseHighlightTicksLeft";
    private static final String VELOCITY_TAG = "SixthSenseIsMoving";
    protected final DoubleConfig offsetConfig;
    protected final DurationConfig preparingTimeConfig;
    protected final DurationConfig cooldownConfig;
    protected final DurationConfig highlightDurationConfig;

    public SixthSenseEnchantment() {
        super("sixth_sense", Enchantment.Rarity.RARE, EnchantmentCategory.ARMOR_HEAD, EquipmentSlot.HEAD, "SixthSense");
        String offsetComment = "Maximum distance in blocks from player to entity.";
        this.offsetConfig = new DoubleConfig("offset", offsetComment, false, 15.0, 1.0, 100.0);
        String preparingComment = "Duration of standing still before the entities will be highlighted.";
        this.preparingTimeConfig = new DurationConfig("preparing_time", preparingComment, false, 3.5, 1.0, 60.0);
        String cooldownComment = "Duration between calculating entities to glow.";
        this.cooldownConfig = new DurationConfig("cooldown", cooldownComment, false, 0.5, 0.1, 10.0);
        String highlightComment = "Duration of entities being highlighted.";
        this.highlightDurationConfig = new DurationConfig("highlight_duration", highlightComment, false, 5.0, 0.5, 60.0);
        this.enchantmentGroup.addConfigs(new IConfig[]{this.offsetConfig, this.preparingTimeConfig, this.cooldownConfig, this.highlightDurationConfig});
        this.setMaximumEnchantmentLevel(1);
        this.setDifferenceBetweenMinimumAndMaximum(30);
        this.setMinimumEnchantabilityCalculator(level -> 12);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (TimeHelper.isEndPhase((TickEvent)event)) {
            Instances.SIXTH_SENSE.update(event.player);
        }
    }

    @SubscribeEvent
    public static void onEntityTick(LivingEvent.LivingUpdateEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        NBTHelper.IntegerData monsterTagData = new NBTHelper.IntegerData(livingEntity, ENEMY_TAG);
        if (livingEntity.f_19853_ instanceof ServerLevel) {
            monsterTagData.set(value -> Math.max(value - 1, 0));
        }
        if (monsterTagData.get() == 1) {
            livingEntity.m_146915_(false);
        }
    }

    private void update(Player player) {
        NBTHelper.IntegerData senseTagData = new NBTHelper.IntegerData((LivingEntity)player, SENSE_TAG);
        NBTHelper.BooleanData velocityData = new NBTHelper.BooleanData((LivingEntity)player, VELOCITY_TAG);
        if (player.f_19853_ instanceof ServerLevel) {
            boolean isPlayerMoving = velocityData.get();
            senseTagData.set(isPlayerMoving ? value -> 0 : value -> value + 1);
        } else if (TimeHelper.hasClientSecondsPassed((double)0.25)) {
            PacketHandler.CHANNEL.sendToServer((Object)new VelocityMessage(this.hasPlayerMoved(player)));
        }
        if (this.hasEnchantment(player.m_6844_(EquipmentSlot.HEAD)) && this.shouldHighlightEntities(senseTagData)) {
            this.highlightNearbyEntities(player);
        }
    }

    private void highlightNearbyEntities(Player player) {
        AABB axisAligned = AABBHelper.createInflatedAABB((Vec3)player.m_20182_(), (double)this.offsetConfig.get());
        Predicate<LivingEntity> predicate = entity -> VectorHelper.distance((Vec3)entity.m_20182_(), (Vec3)player.m_20182_()) < this.offsetConfig.get();
        for (LivingEntity livingEntity : player.f_19853_.m_6443_(LivingEntity.class, axisAligned, predicate)) {
            if (livingEntity == player) continue;
            NBTHelper.IntegerData monsterTagData = new NBTHelper.IntegerData(livingEntity, ENEMY_TAG);
            monsterTagData.set(Integer.valueOf(this.highlightDurationConfig.getDuration()));
            livingEntity.m_146915_(true);
        }
    }

    private boolean shouldHighlightEntities(NBTHelper.IntegerData senseTagData) {
        int currentStandingStillTicks = senseTagData.get();
        int preparingTimeInTicks = this.preparingTimeConfig.getDuration();
        int cooldownTicks = this.cooldownConfig.getDuration();
        return currentStandingStillTicks == preparingTimeInTicks || currentStandingStillTicks > preparingTimeInTicks && TimeHelper.hasServerTicksPassed((int)cooldownTicks);
    }

    private boolean hasPlayerMoved(Player player) {
        return player.f_19854_ != player.m_20185_() || player.f_19855_ != player.m_20186_() || player.f_19856_ != player.m_20189_();
    }

    public static class VelocityMessage
    extends BooleanMessage {
        public VelocityMessage(boolean value) {
            super(value);
        }

        public VelocityMessage(FriendlyByteBuf buffer) {
            super(buffer);
        }

        public void receiveMessage(ServerPlayer sender, NetworkEvent.Context context) {
            NBTHelper.BooleanData velocityData = new NBTHelper.BooleanData((LivingEntity)sender, SixthSenseEnchantment.VELOCITY_TAG);
            velocityData.set(Boolean.valueOf(this.value));
        }
    }
}

