/*
 * Decompiled with CFR 0.152.
 */
package com.wonderfulenchantments.enchantments;

import com.mlib.config.AvailabilityConfig;
import com.mlib.config.IConfig;
import com.mlib.config.StringListConfig;
import com.wonderfulenchantments.enchantments.WonderfulEnchantment;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.UntouchingEnchantment;

public class SmelterEnchantment
extends WonderfulEnchantment {
    protected final AvailabilityConfig shouldIncreaseLoot;
    protected final StringListConfig fortuneBonusList;

    public SmelterEnchantment() {
        super("smelter", Enchantment.Rarity.UNCOMMON, EnchantmentCategory.DIGGER, EquipmentSlot.MAINHAND, "Smelter");
        String lootComment = "Should this enchantment duplicate custom items when a player have fortune enchantment.";
        this.shouldIncreaseLoot = new AvailabilityConfig("should_increase_loot", lootComment, false, true);
        String bonusComment = "List of blocks that drops more items when a player has both Fortune and Smelter enchantment.";
        this.fortuneBonusList = new StringListConfig("fortune_bonus_list", bonusComment, false, new String[]{"for example: minecraft:iron_ore"});
        this.enchantmentGroup.addConfigs(new IConfig[]{this.shouldIncreaseLoot, this.fortuneBonusList});
        this.setMaximumEnchantmentLevel(1);
        this.setDifferenceBetweenMinimumAndMaximum(30);
        this.setMinimumEnchantabilityCalculator(level -> 15 * level);
    }

    public boolean isExtraLootDisabled() {
        return this.shouldIncreaseLoot.isDisabled();
    }

    public boolean shouldIncreaseLoot(ResourceLocation blockLocation) {
        return blockLocation != null && this.fortuneBonusList.contains(blockLocation.toString());
    }

    public boolean m_5975_(Enchantment enchantment) {
        return !(enchantment instanceof UntouchingEnchantment) && super.m_5975_(enchantment);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return !(stack.m_41720_() instanceof HoeItem) && super.canApplyAtEnchantingTable(stack);
    }
}

