/*
 * Decompiled with CFR 0.152.
 */
package com.wonderfulenchantments.enchantments;

import com.mlib.CommonHelper;
import com.mlib.EquipmentSlots;
import com.mlib.attributes.AttributeHandler;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfig;
import com.wonderfulenchantments.Instances;
import com.wonderfulenchantments.RegistryHandler;
import com.wonderfulenchantments.enchantments.WonderfulEnchantment;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class SwiftnessEnchantment
extends WonderfulEnchantment {
    private static final AttributeHandler ATTRIBUTE_HANDLER = new AttributeHandler("76c3bea2-7ef1-4c4b-b062-a12355120ee7", "SwiftnessBonus", Attributes.f_22279_, AttributeModifier.Operation.MULTIPLY_BASE);
    protected final DoubleConfig movementMultiplier;

    public SwiftnessEnchantment() {
        super("swiftness", Enchantment.Rarity.RARE, RegistryHandler.HORSE_ARMOR, EquipmentSlots.ARMOR, "Swiftness");
        String comment = "Horse movement speed multiplier per enchantment level.";
        this.movementMultiplier = new DoubleConfig("movement_multiplier", comment, false, 0.125, 0.01, 0.5);
        this.enchantmentGroup.addConfig((IConfig)this.movementMultiplier);
        this.setMaximumEnchantmentLevel(4);
        this.setDifferenceBetweenMinimumAndMaximum(20);
        this.setMinimumEnchantabilityCalculator(level -> 5 * level);
    }

    @SubscribeEvent
    public static void onEquipmentChange(LivingEquipmentChangeEvent event) {
        Animal animal = (Animal)CommonHelper.castIfPossible(Animal.class, (Object)event.getEntityLiving());
        if (animal != null) {
            ATTRIBUTE_HANDLER.setValueAndApply((LivingEntity)animal, Instances.SWIFTNESS.getMovementSpeedMultiplier(animal));
        }
    }

    protected double getMovementSpeedMultiplier(Animal animal) {
        return (double)this.getEnchantmentSum(animal.m_6168_()) * this.movementMultiplier.get();
    }
}

