/*
 * Decompiled with CFR 0.152.
 */
package com.wonderfulenchantments.enchantments;

import com.mlib.EquipmentSlots;
import com.mlib.attributes.AttributeHandler;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfig;
import com.mlib.enchantments.EnchantmentHelperPlus;
import com.wonderfulenchantments.Instances;
import com.wonderfulenchantments.RegistryHandler;
import com.wonderfulenchantments.enchantments.WonderfulEnchantment;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class VitalityEnchantment
extends WonderfulEnchantment {
    private static final AttributeHandler ATTRIBUTE_HANDLER = new AttributeHandler("575cb29a-1ee4-11eb-adc1-0242ac120002", "VitalityBonus", Attributes.f_22276_, AttributeModifier.Operation.ADDITION);
    protected final DoubleConfig healthBonus;

    public VitalityEnchantment() {
        super("vitality", Enchantment.Rarity.UNCOMMON, RegistryHandler.SHIELD, EquipmentSlots.BOTH_HANDS, "Vitality");
        String comment = "Health bonus per enchantment level.";
        this.healthBonus = new DoubleConfig("health_bonus", comment, false, 2.0, 1.0, 20.0);
        this.enchantmentGroup.addConfig((IConfig)this.healthBonus);
        this.setMaximumEnchantmentLevel(3);
        this.setDifferenceBetweenMinimumAndMaximum(10);
        this.setMinimumEnchantabilityCalculator(level -> 5 + 8 * level);
    }

    @SubscribeEvent
    public static void onEquipmentChange(LivingEquipmentChangeEvent event) {
        LivingEntity entity = event.getEntityLiving();
        ATTRIBUTE_HANDLER.setValueAndApply(entity, VitalityEnchantment.getHealthBonus(entity));
    }

    protected static double getHealthBonus(LivingEntity livingEntity) {
        int sum = EnchantmentHelperPlus.calculateEnchantmentSumIfIsInstanceOf((Enchantment)Instances.VITALITY, (LivingEntity)livingEntity, (EquipmentSlot[])EquipmentSlots.BOTH_HANDS, ShieldItem.class);
        return (double)sum * Instances.VITALITY.healthBonus.get();
    }
}

