/*
 * Decompiled with CFR 0.152.
 */
package com.wonderfulenchantments.items;

import com.mlib.MajruszLibrary;
import com.mlib.TimeConverter;
import com.mlib.config.ConfigGroup;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfig;
import com.mlib.config.IntegerConfig;
import com.mlib.entities.EntityHelper;
import com.wonderfulenchantments.WonderfulEnchantments;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WonderfulBookItem
extends Item {
    private static final String BOOK_TAG = "wonderful_book";
    private static final String ENERGY_TAG = "energy";
    protected final ConfigGroup itemGroup;
    protected final IntegerConfig startingLevel;
    protected final IntegerConfig maximumLevel;
    protected final IntegerConfig minimumCost;
    protected final IntegerConfig amountOfBooks;
    protected final DoubleConfig costRatio;

    public WonderfulBookItem() {
        super(new Item.Properties().m_41487_(1).m_41491_(CreativeModeTab.f_40753_).m_41497_(Rarity.UNCOMMON));
        String startComment = "Starting enchanting energy level.";
        this.startingLevel = new IntegerConfig("starting_level", startComment, false, 6, 6, 100);
        String maximumComment = "Maximum level of enchanting energy.";
        this.maximumLevel = new IntegerConfig("maximum_level", maximumComment, false, 30, 6, 100);
        String minimumComment = "Minimum cost of enchanting.";
        this.minimumCost = new IntegerConfig("minimum_cost", minimumComment, false, 6, 6, 100);
        String bookComment = "Amount of books combined together.";
        this.amountOfBooks = new IntegerConfig("book_amount", bookComment, false, 3, 1, 10);
        String ratioComment = "Enchanting cost ratio for each extra level beyond starting enchanting energy level.";
        this.costRatio = new DoubleConfig("cost_ratio", ratioComment, false, 0.75, 0.0, 1.0);
        this.itemGroup = (ConfigGroup)WonderfulEnchantments.ITEM_GROUP.addGroup((IConfig)new ConfigGroup("WonderfulBook", ""));
        this.itemGroup.addConfigs(new IConfig[]{this.startingLevel, this.maximumLevel, this.minimumCost, this.amountOfBooks, this.costRatio});
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack wonderfulBook = player.m_21120_(hand);
        if (!world.f_46443_) {
            int levelCost = this.getEnchantingLevelCost(wonderfulBook);
            boolean isOnCreativeMode = EntityHelper.isOnCreativeMode((Player)player);
            if (player.f_36078_ >= levelCost) {
                if (!isOnCreativeMode) {
                    player.m_6749_(-levelCost);
                }
            } else if (!isOnCreativeMode) {
                return InteractionResultHolder.m_19092_((Object)wonderfulBook, (boolean)world.m_5776_());
            }
            ItemStack enchantedBook = new ItemStack((ItemLike)Items.f_42690_);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            world.m_5594_(null, player.m_142538_(), SoundEvents.f_11887_, SoundSource.AMBIENT, 0.75f, 0.75f);
            ArrayList<EnchantmentInstance> enchantmentDataList = new ArrayList<EnchantmentInstance>();
            for (int i = 0; i < this.amountOfBooks.get(); ++i) {
                enchantmentDataList.addAll(EnchantmentHelper.m_44909_((Random)MajruszLibrary.RANDOM, (ItemStack)new ItemStack((ItemLike)Items.f_42517_), (int)this.getEnergyLevel(wonderfulBook), (boolean)false));
            }
            this.removeIncompatibleEnchantments(enchantmentDataList);
            for (EnchantmentInstance enchantmentData : enchantmentDataList) {
                EnchantedBookItem.m_41153_((ItemStack)enchantedBook, (EnchantmentInstance)enchantmentData);
            }
            player.m_21008_(hand, enchantedBook);
            return InteractionResultHolder.m_19092_((Object)enchantedBook, (boolean)world.m_5776_());
        }
        return InteractionResultHolder.m_19092_((Object)wonderfulBook, (boolean)world.m_5776_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack itemStack, @Nullable Level world, List<Component> toolTip, TooltipFlag flag) {
        TranslatableComponent energyText;
        if (this.hasMaximumEnergyLevel(itemStack) && world != null && world.m_46467_() / (long)TimeConverter.secondsToTicks((double)2.0) % 3L == 0L) {
            energyText = new TranslatableComponent("item.wonderful_enchantments.wonderful_book.enchanting_energy_max");
            energyText.m_130940_(ChatFormatting.BLUE);
        } else {
            energyText = new TranslatableComponent("item.wonderful_enchantments.wonderful_book.enchanting_energy");
            energyText.m_130946_(" " + this.getEnergyLevel(itemStack) + " ");
            energyText.m_7220_((Component)new TranslatableComponent("item.wonderful_enchantments.wonderful_book.level"));
            energyText.m_130940_(ChatFormatting.GRAY);
        }
        toolTip.add((Component)energyText);
        TranslatableComponent costText = new TranslatableComponent("item.wonderful_enchantments.wonderful_book.enchanting_cost");
        costText.m_130946_(" " + this.getEnchantingLevelCost(itemStack) + " ");
        costText.m_7220_((Component)new TranslatableComponent("item.wonderful_enchantments.wonderful_book.levels"));
        costText.m_130940_(ChatFormatting.GRAY);
        toolTip.add((Component)costText);
        if (this.getEnergyLevel(itemStack) < this.startingLevel.get() + 1) {
            toolTip.add((Component)new TextComponent(" "));
            toolTip.add((Component)new TranslatableComponent("item.wonderful_enchantments.wonderful_book.hint").m_130940_(ChatFormatting.GRAY));
        }
        toolTip.add((Component)new TextComponent(" "));
        toolTip.add((Component)new TranslatableComponent("item.wonderful_enchantments.wonderful_book.transmute").m_130940_(ChatFormatting.GRAY));
    }

    public void m_6787_(CreativeModeTab itemGroup, NonNullList<ItemStack> itemStacks) {
        if (itemGroup != CreativeModeTab.f_40753_) {
            return;
        }
        double max = this.maximumLevel.get().intValue();
        double min = this.startingLevel.get().intValue();
        double range = max - min;
        for (int i = 0; i <= 2; ++i) {
            ItemStack wonderfulBook = new ItemStack((ItemLike)this);
            this.setEnergyLevel(wonderfulBook, (int)(min + range * (double)i / 2.0));
            itemStacks.add((Object)wonderfulBook);
        }
    }

    public int getEnergyLevel(ItemStack itemStack) {
        CompoundTag compoundNBT = itemStack.m_41737_(BOOK_TAG);
        return compoundNBT != null && compoundNBT.m_128425_(ENERGY_TAG, 99) ? compoundNBT.m_128451_(ENERGY_TAG) : this.startingLevel.get().intValue();
    }

    public void setEnergyLevel(ItemStack itemStack, int energyLevel) {
        CompoundTag compoundNBT = itemStack.m_41698_(BOOK_TAG);
        compoundNBT.m_128405_(ENERGY_TAG, Math.max(this.startingLevel.get(), Math.min(energyLevel, this.maximumLevel.get())));
    }

    public ItemStack energizeBook(ItemStack itemStack, List<ItemStack> energizingItemsList) {
        this.setEnergyLevel(itemStack, this.getEnergyLevel(itemStack) + energizingItemsList.size());
        return itemStack;
    }

    public int getEnchantingLevelCost(ItemStack itemStack) {
        return this.minimumCost.get() + (int)Math.max(0.0, (double)(this.getEnergyLevel(itemStack) - this.minimumCost.get()) * this.costRatio.get());
    }

    public boolean hasMaximumEnergyLevel(ItemStack itemStack) {
        return this.getEnergyLevel(itemStack) >= this.maximumLevel.get();
    }

    private void removeIncompatibleEnchantments(List<EnchantmentInstance> enchantmentDataList) {
        int size = enchantmentDataList.size();
        for (int i = 0; i < size - 1; ++i) {
            EnchantmentInstance current = enchantmentDataList.get(i);
            int j = i + 1;
            while (j < size) {
                EnchantmentInstance next = enchantmentDataList.get(j);
                if (!current.f_44947_.m_44695_(next.f_44947_)) {
                    enchantmentDataList.remove(j);
                    --size;
                    continue;
                }
                ++j;
            }
        }
    }
}

