/*
 * Decompiled with CFR 0.152.
 */
package com.wonderfulenchantments.loot_modifiers;

import com.google.gson.JsonObject;
import com.mlib.loot_modifiers.LootHelper;
import com.wonderfulenchantments.Instances;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;

public class AddItemsDirectlyToInventory
extends LootModifier {
    private final String TELEKINESIS_TIME_TAG = "TelekinesisLastTimeTag";
    private final String TELEKINESIS_POSITION_TAG = "TelekinesisLastPositionTag";

    public AddItemsDirectlyToInventory(LootItemCondition[] conditions) {
        super(conditions);
    }

    @Nonnull
    public List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        ItemStack tool = (ItemStack)LootHelper.getParameter((LootContext)context, (LootContextParam)LootContextParams.f_81463_);
        Vec3 position = (Vec3)LootHelper.getParameter((LootContext)context, (LootContextParam)LootContextParams.f_81460_);
        Entity entity = (Entity)LootHelper.getParameter((LootContext)context, (LootContextParam)LootContextParams.f_81455_);
        if (tool == null || position == null || !(entity instanceof Player)) {
            return generatedLoot;
        }
        Player player = (Player)entity;
        if (this.isSameTimeAsPreviousTelekinesisTick(player) && this.isSamePosition(player, position)) {
            generatedLoot.clear();
            return generatedLoot;
        }
        this.updateLastTelekinesisTime(player);
        this.updateLastBlockPosition(player, position);
        int harvesterLevel = EnchantmentHelper.m_44843_((Enchantment)Instances.HARVESTER, (ItemStack)player.m_21205_());
        Item seedItem = this.getSeedItem(entity.f_19853_, (Vec3)LootHelper.getParameter((LootContext)context, (LootContextParam)LootContextParams.f_81460_), (BlockState)LootHelper.getParameter((LootContext)context, (LootContextParam)LootContextParams.f_81461_));
        ArrayList<ItemStack> output = new ArrayList<ItemStack>();
        for (ItemStack itemStack : generatedLoot) {
            if (harvesterLevel > 0 && itemStack.m_41720_() == seedItem) {
                itemStack.m_41764_(itemStack.m_41613_() - 1);
                boolean didGivingItemSucceeded = player.m_150109_().m_36054_(itemStack);
                output.add(new ItemStack((ItemLike)seedItem, (!didGivingItemSucceeded ? itemStack.m_41613_() : 0) + 1));
                continue;
            }
            if (player.m_150109_().m_36054_(itemStack)) continue;
            output.add(itemStack);
        }
        return output;
    }

    @Nullable
    private Item getSeedItem(Level world, Vec3 position, BlockState blockState) {
        if (blockState == null || position == null) {
            return null;
        }
        if (!(blockState.m_60734_() instanceof CropBlock)) {
            return null;
        }
        CropBlock crops = (CropBlock)blockState.m_60734_();
        ItemStack seeds = crops.m_7397_((BlockGetter)world, new BlockPos(position), blockState);
        return seeds.m_41720_();
    }

    private void updateLastTelekinesisTime(Player player) {
        Level world = player.f_19853_;
        CompoundTag data = player.getPersistentData();
        data.m_128356_("TelekinesisLastTimeTag", world.m_46468_());
    }

    private boolean isSameTimeAsPreviousTelekinesisTick(Player player) {
        Level world = player.f_19853_;
        CompoundTag data = player.getPersistentData();
        return data.m_128454_("TelekinesisLastTimeTag") == world.m_46468_();
    }

    private void updateLastBlockPosition(Player player, Vec3 position) {
        CompoundTag data = player.getPersistentData();
        data.m_128359_("TelekinesisLastPositionTag", position.toString());
    }

    private boolean isSamePosition(Player player, Vec3 position) {
        CompoundTag data = player.getPersistentData();
        return data.m_128461_("TelekinesisLastPositionTag").equals(position.toString());
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<AddItemsDirectlyToInventory> {
        public AddItemsDirectlyToInventory read(ResourceLocation name, JsonObject object, LootItemCondition[] conditions) {
            return new AddItemsDirectlyToInventory(conditions);
        }

        public JsonObject write(AddItemsDirectlyToInventory instance) {
            return null;
        }
    }
}

