/*
 * Decompiled with CFR 0.152.
 */
package com.wonderfulenchantments.loot_modifiers;

import com.google.gson.JsonObject;
import com.mlib.Random;
import com.mlib.loot_modifiers.LootHelper;
import com.wonderfulenchantments.Instances;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;

public class Replant
extends LootModifier {
    public Replant(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @Nonnull
    public List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        BlockState blockState = (BlockState)LootHelper.getParameter((LootContext)context, (LootContextParam)LootContextParams.f_81461_);
        Entity entity = (Entity)LootHelper.getParameter((LootContext)context, (LootContextParam)LootContextParams.f_81455_);
        ItemStack hoe = (ItemStack)LootHelper.getParameter((LootContext)context, (LootContextParam)LootContextParams.f_81463_);
        Vec3 origin = (Vec3)LootHelper.getParameter((LootContext)context, (LootContextParam)LootContextParams.f_81460_);
        if (blockState == null || entity == null || hoe == null || origin == null || !Replant.isAtMaxAge(blockState)) {
            return generatedLoot;
        }
        BlockPos position = new BlockPos(origin);
        int rangeFactor = Instances.HARVESTER.range.get() * EnchantmentHelper.m_44843_((Enchantment)Instances.HARVESTER, (ItemStack)hoe);
        Replant.removeSeedsFromLoot(generatedLoot, entity.f_19853_, blockState, position);
        if (entity.f_19853_ instanceof ServerLevel && entity instanceof LivingEntity) {
            Replant.tickInRange(rangeFactor, (ServerLevel)entity.f_19853_, position, (LivingEntity)entity, hoe);
        }
        return generatedLoot;
    }

    protected static boolean isAtMaxAge(BlockState blockState) {
        Block block = blockState.m_60734_();
        if (block instanceof CropBlock) {
            CropBlock crops = (CropBlock)block;
            return crops.m_52307_(blockState);
        }
        if (block instanceof NetherWartBlock) {
            int netherWartMaximumAge = 3;
            return (Integer)blockState.m_61143_((Property)NetherWartBlock.f_54967_) >= netherWartMaximumAge;
        }
        return false;
    }

    protected static void removeSeedsFromLoot(List<ItemStack> generatedLoot, Level world, BlockState blockState, BlockPos position) {
        Block block = blockState.m_60734_();
        Item seedItem = Replant.getSeedItem(world, blockState, position);
        for (ItemStack itemStack : generatedLoot) {
            if (itemStack.m_41720_() != seedItem) continue;
            itemStack.m_41764_(itemStack.m_41613_() - 1);
            world.m_46597_(position, block.m_49966_());
            return;
        }
        world.m_46597_(position, Blocks.f_50016_.m_49966_());
    }

    protected static Item getSeedItem(Level world, BlockState blockState, BlockPos position) {
        Block block = blockState.m_60734_();
        if (block instanceof CropBlock) {
            ItemStack itemStack = ((CropBlock)block).m_7397_((BlockGetter)world, position, blockState);
            return itemStack.m_41720_();
        }
        if (block instanceof NetherWartBlock) {
            ItemStack itemStack = ((NetherWartBlock)block).m_7397_((BlockGetter)world, position, blockState);
            return itemStack.m_41720_();
        }
        return Items.f_42352_;
    }

    protected static void tickInRange(int range, ServerLevel world, BlockPos position, LivingEntity entity, ItemStack hoe) {
        for (int z = -range; z <= range; ++z) {
            for (int x = -range; x <= range; ++x) {
                int penalty;
                double growChance;
                if (x == 0 && z == 0) continue;
                BlockPos neighbourPosition = new BlockPos((Vec3i)position.m_142082_(x, 0, z));
                BlockState blockState = world.m_8055_(neighbourPosition);
                if (blockState.m_60734_() instanceof CropBlock) {
                    CropBlock cropsBlock = (CropBlock)blockState.m_60734_();
                    growChance = Instances.HARVESTER.growChance.get();
                    if (!(growChance > 0.0)) continue;
                    if (Random.tryChance((double)growChance)) {
                        penalty = Instances.HARVESTER.durabilityPenalty.get();
                        cropsBlock.m_52263_((Level)world, neighbourPosition, blockState);
                        Replant.spawnParticles(world, neighbourPosition, 3);
                        if (penalty > 0) {
                            hoe.m_41622_(penalty, entity, owner -> owner.m_21166_(EquipmentSlot.MAINHAND));
                        }
                    }
                    Replant.spawnParticles(world, neighbourPosition, 1);
                    continue;
                }
                if (!(blockState.m_60734_() instanceof NetherWartBlock)) continue;
                NetherWartBlock netherWartBlock = (NetherWartBlock)blockState.m_60734_();
                growChance = Instances.HARVESTER.netherWartGrowChance.get();
                if (!(growChance > 0.0)) continue;
                if (Random.tryChance((double)growChance)) {
                    penalty = Instances.HARVESTER.durabilityPenalty.get();
                    int newAge = Mth.m_14045_((int)((Integer)blockState.m_61143_((Property)NetherWartBlock.f_54967_) + 1), (int)0, (int)3);
                    world.m_46597_(neighbourPosition, (BlockState)netherWartBlock.m_49966_().m_61124_((Property)NetherWartBlock.f_54967_, (Comparable)Integer.valueOf(newAge)));
                    Replant.spawnParticles(world, neighbourPosition, 3);
                    if (penalty > 0) {
                        hoe.m_41622_(penalty, entity, owner -> owner.m_21166_(EquipmentSlot.MAINHAND));
                    }
                }
                Replant.spawnParticles(world, neighbourPosition, 1);
            }
        }
    }

    protected static void spawnParticles(ServerLevel world, BlockPos position, int amount) {
        world.m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)position.m_123341_() + 0.5, (double)position.m_123342_() + 0.5, (double)position.m_123343_() + 0.5, amount, 0.25, 0.25, 0.25, 0.1);
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<Replant> {
        public Replant read(ResourceLocation name, JsonObject object, LootItemCondition[] conditionsIn) {
            return new Replant(conditionsIn);
        }

        public JsonObject write(Replant instance) {
            return null;
        }
    }
}

