/*
 * Decompiled with CFR 0.152.
 */
package com.wonderfulenchantments.loot_modifiers;

import com.google.gson.JsonObject;
import com.mlib.MajruszLibrary;
import com.mlib.Random;
import com.mlib.loot_modifiers.LootHelper;
import com.wonderfulenchantments.Instances;
import com.wonderfulenchantments.enchantments.SmelterEnchantment;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.items.ItemHandlerHelper;

public class SmeltingItems
extends LootModifier {
    public SmeltingItems(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @Nonnull
    public List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        ItemStack tool = (ItemStack)LootHelper.getParameter((LootContext)context, (LootContextParam)LootContextParams.f_81463_);
        Entity entity = (Entity)LootHelper.getParameter((LootContext)context, (LootContextParam)LootContextParams.f_81455_);
        if (tool == null || !(entity instanceof Player)) {
            return generatedLoot;
        }
        Player player = (Player)entity;
        if (player.m_6047_()) {
            return generatedLoot;
        }
        int fortuneLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)tool);
        return this.getSmeltedLoot(generatedLoot, context.m_78952_(), (Vec3)LootHelper.getParameter((LootContext)context, (LootContextParam)LootContextParams.f_81460_), fortuneLevel);
    }

    protected static ItemStack smeltIfPossible(ItemStack itemStack, ServerLevel world) {
        return world.m_7465_().m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{itemStack}), (Level)world).map(AbstractCookingRecipe::m_8043_).filter(i -> !i.m_41619_()).map(i -> ItemHandlerHelper.copyStackWithSize((ItemStack)i, (int)(itemStack.m_41613_() * i.m_41613_()))).orElse(itemStack);
    }

    protected static int calculateRandomExperienceForRecipe(SmeltingRecipe recipe, int smeltedItems) {
        return Random.randomizeExperience((double)(recipe.m_43750_() * (float)smeltedItems));
    }

    protected static ItemStack getSmeltedItemStack(ItemStack itemStackToSmelt, ServerLevel world) {
        ItemStack smeltedItemStack = SmeltingItems.smeltIfPossible(itemStackToSmelt, world);
        if (smeltedItemStack.m_41613_() != itemStackToSmelt.m_41613_()) {
            smeltedItemStack.m_41764_(itemStackToSmelt.m_41613_());
        }
        return smeltedItemStack;
    }

    protected static void affectByFortune(int fortuneLevel, ItemStack itemStack) {
        itemStack.m_41764_(itemStack.m_41613_() * (1 + MajruszLibrary.RANDOM.nextInt(fortuneLevel + 1)));
    }

    protected List<ItemStack> getSmeltedLoot(List<ItemStack> generatedLoot, ServerLevel world, Vec3 position, int fortuneLevel) {
        RecipeManager recipeManager = world.m_7465_();
        ArrayList<ItemStack> output = new ArrayList<ItemStack>();
        for (ItemStack itemStack : generatedLoot) {
            ItemStack smeltedItemStack = SmeltingItems.getSmeltedItemStack(itemStack, world);
            if (this.isItemAffectedByFortune(itemStack.m_41720_()) && fortuneLevel > 0) {
                SmeltingItems.affectByFortune(fortuneLevel, smeltedItemStack);
            }
            output.add(smeltedItemStack);
            Optional recipe = recipeManager.m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{itemStack}), (Level)world);
            if (recipe.isEmpty()) continue;
            int experience = SmeltingItems.calculateRandomExperienceForRecipe((SmeltingRecipe)recipe.get(), itemStack.m_41613_());
            if (experience > 0) {
                world.m_7967_((Entity)new ExperienceOrb((Level)world, position.f_82479_, position.f_82480_, position.f_82481_, experience));
            }
            world.m_8767_((ParticleOptions)ParticleTypes.f_123744_, position.f_82479_, position.f_82480_, position.f_82481_, 2 + MajruszLibrary.RANDOM.nextInt(4), 0.125, 0.125, 0.125, 0.03125);
        }
        return output;
    }

    protected boolean isItemAffectedByFortune(Item item) {
        SmelterEnchantment smelter = Instances.SMELTER;
        return !smelter.isExtraLootDisabled() && smelter.shouldIncreaseLoot(item.getRegistryName());
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<SmeltingItems> {
        public SmeltingItems read(ResourceLocation name, JsonObject object, LootItemCondition[] conditionsIn) {
            return new SmeltingItems(conditionsIn);
        }

        public JsonObject write(SmeltingItems instance) {
            return null;
        }
    }
}

