/*
 * Decompiled with CFR 0.152.
 */
package com.wonderfulenchantments.recipes;

import com.google.common.collect.Lists;
import com.wonderfulenchantments.Instances;
import com.wonderfulenchantments.items.WonderfulBookItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class WonderfulBookRecipe
extends CustomRecipe {
    public WonderfulBookRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(CraftingContainer inventory, Level world) {
        ItemStack wonderfulBook = ItemStack.f_41583_;
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack itemStack = inventory.m_8020_(i);
            if (itemStack.m_41619_()) continue;
            if (itemStack.m_41720_() instanceof WonderfulBookItem) {
                if (!wonderfulBook.m_41619_()) {
                    return false;
                }
                wonderfulBook = itemStack;
                continue;
            }
            if (!this.canEnergize(itemStack)) {
                return false;
            }
            list.add(itemStack);
        }
        return this.isValid(wonderfulBook, list);
    }

    public ItemStack assemble(CraftingContainer inventory) {
        ItemStack wonderfulBook = ItemStack.f_41583_;
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack itemStack = inventory.m_8020_(i);
            if (itemStack.m_41619_()) continue;
            Item item = itemStack.m_41720_();
            if (item instanceof WonderfulBookItem) {
                if (!wonderfulBook.m_41619_()) {
                    return ItemStack.f_41583_;
                }
                wonderfulBook = itemStack.m_41777_();
                continue;
            }
            if (!this.canEnergize(itemStack)) {
                return ItemStack.f_41583_;
            }
            list.add(itemStack);
        }
        return this.isValid(wonderfulBook, list) ? Instances.WONDERFUL_BOOK_ITEM.energizeBook(wonderfulBook, list) : ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return Instances.WONDERFUL_BOOK_RECIPE;
    }

    private boolean canEnergize(ItemStack itemStack) {
        return itemStack.m_41720_() == Items.f_42534_;
    }

    private boolean isValid(ItemStack itemStack, List<ItemStack> itemList) {
        return !Instances.WONDERFUL_BOOK_ITEM.hasMaximumEnergyLevel(itemStack) && !itemStack.m_41619_() && !itemList.isEmpty();
    }
}

