/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding;

import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fmllegacy.RegistryObject;
import net.minecraftforge.fmllegacy.network.IContainerFactory;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import nl.requios.effortlessbuilding.BuildConfig;
import nl.requios.effortlessbuilding.capability.ModeCapabilityManager;
import nl.requios.effortlessbuilding.capability.ModifierCapabilityManager;
import nl.requios.effortlessbuilding.compatibility.CompatHelper;
import nl.requios.effortlessbuilding.gui.RandomizerBagContainer;
import nl.requios.effortlessbuilding.item.RandomizerBagItem;
import nl.requios.effortlessbuilding.item.ReachUpgrade1Item;
import nl.requios.effortlessbuilding.item.ReachUpgrade2Item;
import nl.requios.effortlessbuilding.item.ReachUpgrade3Item;
import nl.requios.effortlessbuilding.network.PacketHandler;
import nl.requios.effortlessbuilding.proxy.ClientProxy;
import nl.requios.effortlessbuilding.proxy.IProxy;
import nl.requios.effortlessbuilding.proxy.ServerProxy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="effortlessbuilding")
public class EffortlessBuilding {
    public static final String MODID = "effortlessbuilding";
    public static final Logger logger = LogManager.getLogger();
    public static EffortlessBuilding instance;
    public static IProxy proxy;
    private static final DeferredRegister<Item> ITEMS;
    private static final DeferredRegister<MenuType<?>> CONTAINERS;
    public static final RegistryObject<Item> RANDOMIZER_BAG_ITEM;
    public static final RegistryObject<Item> REACH_UPGRADE_1_ITEM;
    public static final RegistryObject<Item> REACH_UPGRADE_2_ITEM;
    public static final RegistryObject<Item> REACH_UPGRADE_3_ITEM;
    public static final RegistryObject<MenuType<RandomizerBagContainer>> RANDOMIZER_BAG_CONTAINER;
    public static final ResourceLocation RANDOMIZER_BAG_GUI;

    public EffortlessBuilding() {
        instance = this;
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        CONTAINERS.register(FMLJavaModLoadingContext.get().getModEventBus());
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)BuildConfig.spec);
    }

    public static <T extends AbstractContainerMenu> MenuType<T> registerContainer(IContainerFactory<T> fact) {
        MenuType type = new MenuType(fact);
        return type;
    }

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent event) {
        PacketHandler.register();
        proxy.setup(event);
        CompatHelper.setup();
    }

    @SubscribeEvent
    public void clientSetup(FMLClientSetupEvent event) {
        proxy.clientSetup(event);
    }

    @SubscribeEvent
    public void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.register(ModifierCapabilityManager.IModifierCapability.class);
        event.register(ModeCapabilityManager.IModeCapability.class);
    }

    public static void log(String msg) {
        logger.info(msg);
    }

    public static void log(Player player, String msg) {
        EffortlessBuilding.log(player, msg, false);
    }

    public static void log(Player player, String msg, boolean actionBar) {
        player.m_5661_((Component)new TextComponent(msg), actionBar);
    }

    public static void logTranslate(Player player, String prefix, String translationKey, String suffix, boolean actionBar) {
        proxy.logTranslate(player, prefix, translationKey, suffix, actionBar);
    }

    static {
        proxy = (IProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> ServerProxy::new);
        ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)MODID);
        CONTAINERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)MODID);
        RANDOMIZER_BAG_ITEM = ITEMS.register("randomizer_bag", RandomizerBagItem::new);
        REACH_UPGRADE_1_ITEM = ITEMS.register("reach_upgrade_1", ReachUpgrade1Item::new);
        REACH_UPGRADE_2_ITEM = ITEMS.register("reach_upgrade_2", ReachUpgrade2Item::new);
        REACH_UPGRADE_3_ITEM = ITEMS.register("reach_upgrade_3", ReachUpgrade3Item::new);
        RANDOMIZER_BAG_CONTAINER = CONTAINERS.register("randomizer_bag", () -> EffortlessBuilding.registerContainer(RandomizerBagContainer::new));
        RANDOMIZER_BAG_GUI = new ResourceLocation(MODID, "randomizer_bag");
    }
}

