/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import java.io.IOException;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.buildmode.BuildModes;
import nl.requios.effortlessbuilding.buildmode.ModeOptions;
import nl.requios.effortlessbuilding.render.BuildRenderTypes;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ModClientEventHandler {
    private static final HashMap<BuildModes.BuildModeEnum, ResourceLocation> buildModeIcons = new HashMap();
    private static final HashMap<ModeOptions.ActionEnum, ResourceLocation> modeOptionIcons = new HashMap();

    @SubscribeEvent
    public static void onTextureStitch(TextureStitchEvent.Pre event) {
        ResourceLocation spriteLocation;
        EffortlessBuilding.log("Stitching textures");
        for (BuildModes.BuildModeEnum buildModeEnum : BuildModes.BuildModeEnum.values()) {
            spriteLocation = new ResourceLocation("effortlessbuilding", "icons/" + buildModeEnum.name().toLowerCase());
            event.addSprite(spriteLocation);
            buildModeIcons.put(buildModeEnum, spriteLocation);
        }
        for (Enum enum_ : ModeOptions.ActionEnum.values()) {
            spriteLocation = new ResourceLocation("effortlessbuilding", "icons/" + enum_.name().toLowerCase());
            event.addSprite(spriteLocation);
            modeOptionIcons.put((ModeOptions.ActionEnum)enum_, spriteLocation);
        }
    }

    public static TextureAtlasSprite getBuildModeIcon(BuildModes.BuildModeEnum mode) {
        return Minecraft.m_91087_().m_91304_().m_119428_(TextureAtlas.f_118259_).m_118316_(buildModeIcons.get((Object)mode));
    }

    public static TextureAtlasSprite getModeOptionIcon(ModeOptions.ActionEnum action) {
        return Minecraft.m_91087_().m_91304_().m_119428_(TextureAtlas.f_118259_).m_118316_(modeOptionIcons.get((Object)action));
    }

    @SubscribeEvent
    public static void registerShaders(RegisterShadersEvent event) throws IOException {
        event.registerShader(new ShaderInstance((ResourceProvider)event.getResourceManager(), new ResourceLocation("effortlessbuilding", "dissolve"), DefaultVertexFormat.f_85811_), shaderInstance -> {
            BuildRenderTypes.dissolveShaderInstance = shaderInstance;
        });
    }
}

