/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.buildmode;

import javax.annotation.Nonnull;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fmllegacy.network.PacketDistributor;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.buildmode.BuildModes;
import nl.requios.effortlessbuilding.capability.ModeCapabilityManager;
import nl.requios.effortlessbuilding.helper.ReachHelper;
import nl.requios.effortlessbuilding.network.ModeSettingsMessage;
import nl.requios.effortlessbuilding.network.PacketHandler;

@Mod.EventBusSubscriber
public class ModeSettingsManager {
    private static ModeSettings cache = null;

    @Nonnull
    public static ModeSettings getModeSettings(Player player) {
        if (cache != null) {
            return cache;
        }
        LazyOptional modeCapability = player.getCapability(ModeCapabilityManager.MODE_CAPABILITY, null);
        if (modeCapability.isPresent()) {
            ModeCapabilityManager.IModeCapability capability = (ModeCapabilityManager.IModeCapability)modeCapability.orElse(null);
            cache = capability.getModeData();
            if (cache == null) {
                cache = new ModeSettings();
                capability.setModeData(cache);
            }
            modeCapability.addListener(self -> {
                cache = null;
            });
            return capability.getModeData();
        }
        EffortlessBuilding.logger.warn("Player does not have modeCapability: " + player);
        return new ModeSettings();
    }

    public static void setModeSettings(Player player, ModeSettings modeSettings) {
        if (player == null) {
            EffortlessBuilding.log("Cannot set buildmode settings, player is null");
            return;
        }
        LazyOptional modeCapability = player.getCapability(ModeCapabilityManager.MODE_CAPABILITY, null);
        modeCapability.ifPresent(capability -> {
            capability.setModeData(modeSettings);
            BuildModes.initializeMode(player);
        });
        if (!modeCapability.isPresent()) {
            EffortlessBuilding.log(player, "Saving buildmode settings failed.");
        }
    }

    public static String sanitize(ModeSettings modeSettings, Player player) {
        int maxReach = ReachHelper.getMaxReach(player);
        String error = "";
        return error;
    }

    public static void handleNewPlayer(Player player) {
        ModeSettingsManager.getModeSettings(player);
        if (!player.f_19853_.f_46443_) {
            ModeSettingsMessage msg = new ModeSettingsMessage(ModeSettingsManager.getModeSettings(player));
            PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)msg);
        }
    }

    public static class ModeSettings {
        private BuildModes.BuildModeEnum buildMode = BuildModes.BuildModeEnum.NORMAL;

        public ModeSettings() {
        }

        public ModeSettings(BuildModes.BuildModeEnum buildMode) {
            this.buildMode = buildMode;
        }

        public BuildModes.BuildModeEnum getBuildMode() {
            return this.buildMode;
        }

        public void setBuildMode(BuildModes.BuildModeEnum buildMode) {
            this.buildMode = buildMode;
        }
    }
}

