/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.buildmodifier;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import nl.requios.effortlessbuilding.buildmodifier.BuildModifiers;
import nl.requios.effortlessbuilding.buildmodifier.ModifierSettingsManager;
import nl.requios.effortlessbuilding.item.RandomizerBagItem;

public class RadialMirror {
    public static List<BlockPos> findCoordinates(Player player, BlockPos startPos) {
        ArrayList<BlockPos> coordinates = new ArrayList<BlockPos>();
        RadialMirrorSettings r = ModifierSettingsManager.getModifierSettings(player).getRadialMirrorSettings();
        if (!RadialMirror.isEnabled(r, startPos)) {
            return coordinates;
        }
        double sliceAngle = Math.PI * 2 / (double)r.slices;
        Vec3 startVec = new Vec3((double)((float)startPos.m_123341_() + 0.5f), (double)((float)startPos.m_123342_() + 0.5f), (double)((float)startPos.m_123343_() + 0.5f));
        Vec3 relStartVec = startVec.m_82546_(r.position);
        double startAngleToCenter = Mth.m_14136_((double)relStartVec.f_82479_, (double)relStartVec.f_82481_);
        if (startAngleToCenter < 0.0) {
            startAngleToCenter += Math.PI;
        }
        double startAngleInSlice = startAngleToCenter % sliceAngle;
        for (int i = 1; i < r.slices; ++i) {
            Vec3 relNewVec;
            BlockPos newBlockPos;
            double curAngle = sliceAngle * (double)i;
            if (r.alternate && i % 2 == 1) {
                curAngle = curAngle - startAngleInSlice + (sliceAngle - startAngleInSlice);
            }
            if (coordinates.contains(newBlockPos = new BlockPos(r.position.m_82549_(relNewVec = relStartVec.m_82524_((float)curAngle)))) || newBlockPos.equals((Object)startPos)) continue;
            coordinates.add(newBlockPos);
        }
        return coordinates;
    }

    public static List<BlockState> findBlockStates(Player player, BlockPos startPos, BlockState blockState, ItemStack itemStack, List<ItemStack> itemStacks) {
        ArrayList<BlockState> blockStates = new ArrayList<BlockState>();
        ArrayList<BlockPos> coordinates = new ArrayList<BlockPos>();
        RadialMirrorSettings r = ModifierSettingsManager.getModifierSettings(player).getRadialMirrorSettings();
        if (!RadialMirror.isEnabled(r, startPos)) {
            return blockStates;
        }
        double sliceAngle = Math.PI * 2 / (double)r.slices;
        Vec3 startVec = new Vec3((double)((float)startPos.m_123341_() + 0.5f), (double)((float)startPos.m_123342_() + 0.5f), (double)((float)startPos.m_123343_() + 0.5f));
        Vec3 relStartVec = startVec.m_82546_(r.position);
        double startAngleToCenter = Mth.m_14136_((double)relStartVec.f_82479_, (double)relStartVec.f_82481_);
        double startAngleToCenterMod = startAngleToCenter < 0.0 ? startAngleToCenter + Math.PI : startAngleToCenter;
        double startAngleInSlice = startAngleToCenterMod % sliceAngle;
        blockState = RadialMirror.rotateOriginalBlockState(startAngleToCenter, blockState);
        IItemHandler bagInventory = null;
        if (!itemStack.m_41619_() && itemStack.m_41720_() instanceof RandomizerBagItem) {
            bagInventory = RandomizerBagItem.getBagInventory(itemStack);
        }
        for (int i = 1; i < r.slices; ++i) {
            Vec3 relNewVec;
            BlockPos newBlockPos;
            BlockState newBlockState = blockState;
            double curAngle = sliceAngle * (double)i;
            if (r.alternate && i % 2 == 1) {
                curAngle = curAngle - startAngleInSlice + (sliceAngle - startAngleInSlice);
            }
            if (coordinates.contains(newBlockPos = new BlockPos(r.position.m_82549_(relNewVec = relStartVec.m_82524_((float)curAngle)))) || newBlockPos.equals((Object)startPos)) continue;
            coordinates.add(newBlockPos);
            if (bagInventory != null) {
                itemStack = RandomizerBagItem.pickRandomStack(bagInventory);
                newBlockState = BuildModifiers.getBlockStateFromItem(itemStack, player, startPos, Direction.UP, new Vec3(0.0, 0.0, 0.0), InteractionHand.MAIN_HAND);
                newBlockState = RadialMirror.rotateOriginalBlockState(startAngleToCenter, newBlockState);
            }
            newBlockState = RadialMirror.rotateBlockState(relNewVec, newBlockState, r.alternate && i % 2 == 1);
            blockStates.add(newBlockState);
            itemStacks.add(itemStack);
        }
        return blockStates;
    }

    private static BlockState rotateOriginalBlockState(double startAngleToCenter, BlockState blockState) {
        BlockState newBlockState = blockState;
        if (startAngleToCenter < -2.3593360828459344 || startAngleToCenter > 2.3530528975387552) {
            newBlockState = blockState.m_60717_(Rotation.CLOCKWISE_180);
        } else if (startAngleToCenter < -0.7885397560510381) {
            newBlockState = blockState.m_60717_(Rotation.COUNTERCLOCKWISE_90);
        } else if (startAngleToCenter > 0.7822565707438585) {
            newBlockState = blockState.m_60717_(Rotation.CLOCKWISE_90);
        }
        return newBlockState;
    }

    private static BlockState rotateBlockState(Vec3 relVec, BlockState blockState, boolean alternate) {
        BlockState newBlockState;
        double angleToCenter = Mth.m_14136_((double)relVec.f_82479_, (double)relVec.f_82481_);
        if (angleToCenter < -2.3593360828459344 || angleToCenter > 2.3530528975387552) {
            newBlockState = blockState.m_60717_(Rotation.CLOCKWISE_180);
            if (alternate) {
                newBlockState = newBlockState.m_60715_(Mirror.FRONT_BACK);
            }
        } else if (angleToCenter < -0.7885397560510381) {
            newBlockState = blockState.m_60717_(Rotation.CLOCKWISE_90);
            if (alternate) {
                newBlockState = newBlockState.m_60715_(Mirror.LEFT_RIGHT);
            }
        } else if (angleToCenter > 0.7822565707438585) {
            newBlockState = blockState.m_60717_(Rotation.COUNTERCLOCKWISE_90);
            if (alternate) {
                newBlockState = newBlockState.m_60715_(Mirror.LEFT_RIGHT);
            }
        } else {
            newBlockState = blockState;
            if (alternate) {
                newBlockState = newBlockState.m_60715_(Mirror.FRONT_BACK);
            }
        }
        return newBlockState;
    }

    public static boolean isEnabled(RadialMirrorSettings r, BlockPos startPos) {
        if (r == null || !r.enabled) {
            return false;
        }
        return !(new Vec3((double)startPos.m_123341_() + 0.5, (double)startPos.m_123342_() + 0.5, (double)startPos.m_123343_() + 0.5).m_82546_(r.position).m_82556_() > (double)(r.radius * r.radius));
    }

    public static class RadialMirrorSettings {
        public boolean enabled = false;
        public Vec3 position = new Vec3(0.5, 64.5, 0.5);
        public int slices = 4;
        public boolean alternate = false;
        public int radius = 20;
        public boolean drawLines = true;
        public boolean drawPlanes = false;

        public RadialMirrorSettings() {
        }

        public RadialMirrorSettings(boolean enabled, Vec3 position, int slices, boolean alternate, int radius, boolean drawLines, boolean drawPlanes) {
            this.enabled = enabled;
            this.position = position;
            this.slices = slices;
            this.alternate = alternate;
            this.radius = radius;
            this.drawLines = drawLines;
            this.drawPlanes = drawPlanes;
        }

        public int getReach() {
            return this.radius * 2;
        }
    }
}

