/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.compatibility;

import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.item.RandomizerBagItem;

public class CompatHelper {
    public static void setup() {
    }

    public static boolean isItemBlockProxy(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof BlockItem) {
            return true;
        }
        return item instanceof RandomizerBagItem;
    }

    public static ItemStack getItemBlockFromStack(ItemStack proxy) {
        Item proxyItem = proxy.m_41720_();
        if (proxyItem instanceof BlockItem) {
            return proxy;
        }
        if (proxyItem instanceof RandomizerBagItem) {
            ItemStack itemStack = proxy;
            while (!(itemStack.m_41720_() instanceof BlockItem) && !itemStack.m_41619_()) {
                if (!(itemStack.m_41720_() instanceof RandomizerBagItem)) continue;
                itemStack = RandomizerBagItem.pickRandomStack(RandomizerBagItem.getBagInventory(itemStack));
            }
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack getItemBlockByState(ItemStack stack, BlockState state) {
        if (state == null) {
            return ItemStack.f_41583_;
        }
        Item blockItem = Item.m_41439_((Block)state.m_60734_());
        if (stack.m_41720_() instanceof BlockItem) {
            return stack;
        }
        if (stack.m_41720_() instanceof RandomizerBagItem) {
            IItemHandler bagInventory = RandomizerBagItem.getBagInventory(stack);
            return RandomizerBagItem.findStack(bagInventory, blockItem);
        }
        return ItemStack.f_41583_;
    }

    public static void shrinkStack(ItemStack origStack, ItemStack curStack, Player player) {
        curStack.m_41774_(1);
    }

    private static int itemHandlerSlotForItem(ItemStack stack, Item blockItem) {
        LazyOptional itemHandlerLazyOptional = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        IItemHandler handler = (IItemHandler)itemHandlerLazyOptional.orElse(null);
        if (handler == null) {
            EffortlessBuilding.logger.warn("Itemblock proxy has no item handler capability!");
            return -1;
        }
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack ref = handler.getStackInSlot(i);
            if (!(ref.m_41720_() instanceof BlockItem) || ref.m_41720_() != blockItem) continue;
            return i;
        }
        return -1;
    }
}

