/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.gui.buildmodifier;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.buildmodifier.ModifierSettingsManager;
import nl.requios.effortlessbuilding.buildmodifier.RadialMirror;
import nl.requios.effortlessbuilding.gui.elements.GuiCheckBoxFixed;
import nl.requios.effortlessbuilding.gui.elements.GuiCollapsibleScrollEntry;
import nl.requios.effortlessbuilding.gui.elements.GuiIconButton;
import nl.requios.effortlessbuilding.gui.elements.GuiNumberField;
import nl.requios.effortlessbuilding.gui.elements.GuiScrollPane;
import nl.requios.effortlessbuilding.helper.ReachHelper;

@OnlyIn(value=Dist.CLIENT)
public class RadialMirrorSettingsGui
extends GuiCollapsibleScrollEntry {
    protected static final ResourceLocation BUILDING_ICONS = new ResourceLocation("effortlessbuilding", "textures/gui/building_icons.png");
    protected List<Button> radialMirrorButtonList = new ArrayList<Button>();
    protected List<GuiIconButton> radialMirrorIconButtonList = new ArrayList<GuiIconButton>();
    protected List<GuiNumberField> radialMirrorNumberFieldList = new ArrayList<GuiNumberField>();
    private GuiNumberField textRadialMirrorPosX;
    private GuiNumberField textRadialMirrorPosY;
    private GuiNumberField textRadialMirrorPosZ;
    private GuiNumberField textRadialMirrorSlices;
    private GuiNumberField textRadialMirrorRadius;
    private GuiCheckBoxFixed buttonRadialMirrorEnabled;
    private GuiCheckBoxFixed buttonRadialMirrorAlternate;
    private GuiIconButton buttonCurrentPosition;
    private GuiIconButton buttonToggleOdd;
    private GuiIconButton buttonDrawPlanes;
    private GuiIconButton buttonDrawLines;
    private boolean drawPlanes;
    private boolean drawLines;
    private boolean toggleOdd;

    public RadialMirrorSettingsGui(GuiScrollPane scrollPane) {
        super(scrollPane);
    }

    @Override
    public void init(List<Widget> renderables) {
        super.init(renderables);
        int y = this.top - 2;
        this.buttonRadialMirrorEnabled = new GuiCheckBoxFixed(this.left - 15 + 8, y, "", false){

            public void m_5716_(double mouseX, double mouseY) {
                super.m_5716_(mouseX, mouseY);
                RadialMirrorSettingsGui.this.setCollapsed(!RadialMirrorSettingsGui.this.buttonRadialMirrorEnabled.isChecked());
            }
        };
        renderables.add((Widget)this.buttonRadialMirrorEnabled);
        y = this.top + 18;
        this.textRadialMirrorPosX = new GuiNumberField(this.font, renderables, this.left + 58, y, 62, 18);
        this.textRadialMirrorPosX.setNumber(0.0);
        this.textRadialMirrorPosX.setTooltip(Arrays.asList(new TextComponent("The position of the radial mirror."), new TextComponent("For odd numbered builds add 0.5.").m_130940_(ChatFormatting.GRAY)));
        this.radialMirrorNumberFieldList.add(this.textRadialMirrorPosX);
        this.textRadialMirrorPosY = new GuiNumberField(this.font, renderables, this.left + 138, y, 62, 18);
        this.textRadialMirrorPosY.setNumber(64.0);
        this.textRadialMirrorPosY.setTooltip(Arrays.asList(new TextComponent("The position of the radial mirror."), new TextComponent("For odd numbered builds add 0.5.").m_130940_(ChatFormatting.GRAY)));
        this.radialMirrorNumberFieldList.add(this.textRadialMirrorPosY);
        this.textRadialMirrorPosZ = new GuiNumberField(this.font, renderables, this.left + 218, y, 62, 18);
        this.textRadialMirrorPosZ.setNumber(0.0);
        this.textRadialMirrorPosZ.setTooltip(Arrays.asList(new TextComponent("The position of the radial mirror."), new TextComponent("For odd numbered builds add 0.5.").m_130940_(ChatFormatting.GRAY)));
        this.radialMirrorNumberFieldList.add(this.textRadialMirrorPosZ);
        y = this.top + 47;
        this.textRadialMirrorSlices = new GuiNumberField(this.font, renderables, this.left + 55, y, 50, 18);
        this.textRadialMirrorSlices.setNumber(4.0);
        this.textRadialMirrorSlices.setTooltip(Arrays.asList(new TextComponent("The number of repeating slices."), new TextComponent("Minimally 2.").m_130940_(ChatFormatting.GRAY)));
        this.radialMirrorNumberFieldList.add(this.textRadialMirrorSlices);
        this.textRadialMirrorRadius = new GuiNumberField(this.font, renderables, this.left + 218, y, 62, 18);
        this.textRadialMirrorRadius.setNumber(50.0);
        this.textRadialMirrorRadius.setTooltip(Arrays.asList(new TextComponent("How far the radial mirror reaches from its center position."), new TextComponent("Max: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(String.valueOf(ReachHelper.getMaxReach((Player)this.mc.f_91074_) / 2)).m_130940_(ChatFormatting.GOLD)), new TextComponent("Upgradeable in survival with reach upgrades.").m_130940_(ChatFormatting.GRAY)));
        this.radialMirrorNumberFieldList.add(this.textRadialMirrorRadius);
        y = this.top + 72;
        this.buttonCurrentPosition = new GuiIconButton(this.left + 5, y, 0, 0, BUILDING_ICONS, button -> {
            Vec3 pos = new Vec3(Math.floor(this.mc.f_91074_.m_20185_()) + 0.5, Math.floor(this.mc.f_91074_.m_20186_()) + 0.5, Math.floor(this.mc.f_91074_.m_20189_()) + 0.5);
            this.textRadialMirrorPosX.setNumber(pos.f_82479_);
            this.textRadialMirrorPosY.setNumber(pos.f_82480_);
            this.textRadialMirrorPosZ.setNumber(pos.f_82481_);
        });
        this.buttonCurrentPosition.setTooltip((Component)new TextComponent("Set radial mirror position to current player position"));
        this.radialMirrorIconButtonList.add(this.buttonCurrentPosition);
        this.buttonToggleOdd = new GuiIconButton(this.left + 35, y, 0, 20, BUILDING_ICONS, button -> {
            this.toggleOdd = !this.toggleOdd;
            this.buttonToggleOdd.setUseAlternateIcon(this.toggleOdd);
            if (this.toggleOdd) {
                this.buttonToggleOdd.setTooltip(Arrays.asList(new TextComponent("Set mirror position to corner of block"), new TextComponent("for even numbered builds")));
                this.textRadialMirrorPosX.setNumber(this.textRadialMirrorPosX.getNumber() + 0.5);
                this.textRadialMirrorPosY.setNumber(this.textRadialMirrorPosY.getNumber() + 0.5);
                this.textRadialMirrorPosZ.setNumber(this.textRadialMirrorPosZ.getNumber() + 0.5);
            } else {
                this.buttonToggleOdd.setTooltip(Arrays.asList(new TextComponent("Set mirror position to middle of block"), new TextComponent("for odd numbered builds")));
                this.textRadialMirrorPosX.setNumber(Math.floor(this.textRadialMirrorPosX.getNumber()));
                this.textRadialMirrorPosY.setNumber(Math.floor(this.textRadialMirrorPosY.getNumber()));
                this.textRadialMirrorPosZ.setNumber(Math.floor(this.textRadialMirrorPosZ.getNumber()));
            }
        });
        this.buttonToggleOdd.setTooltip(Arrays.asList(new TextComponent("Set radial mirror position to middle of block"), new TextComponent("for odd numbered builds")));
        this.radialMirrorIconButtonList.add(this.buttonToggleOdd);
        this.buttonDrawLines = new GuiIconButton(this.left + 65, y, 0, 40, BUILDING_ICONS, button -> {
            this.drawLines = !this.drawLines;
            this.buttonDrawLines.setUseAlternateIcon(this.drawLines);
            this.buttonDrawLines.setTooltip((Component)new TextComponent(this.drawLines ? "Hide lines" : "Show lines"));
        });
        this.buttonDrawLines.setTooltip((Component)new TextComponent("Show lines"));
        this.radialMirrorIconButtonList.add(this.buttonDrawLines);
        this.buttonDrawPlanes = new GuiIconButton(this.left + 95, y, 0, 60, BUILDING_ICONS, button -> {
            this.drawPlanes = !this.drawPlanes;
            this.buttonDrawPlanes.setUseAlternateIcon(this.drawPlanes);
            this.buttonDrawPlanes.setTooltip((Component)new TextComponent(this.drawPlanes ? "Hide area" : "Show area"));
        });
        this.buttonDrawPlanes.setTooltip((Component)new TextComponent("Show area"));
        this.radialMirrorIconButtonList.add(this.buttonDrawPlanes);
        y = this.top + 76;
        this.buttonRadialMirrorAlternate = new GuiCheckBoxFixed(this.left + 140, y, " Alternate", false);
        this.radialMirrorButtonList.add(this.buttonRadialMirrorAlternate);
        ModifierSettingsManager.ModifierSettings modifierSettings = ModifierSettingsManager.getModifierSettings((Player)this.mc.f_91074_);
        if (modifierSettings != null) {
            RadialMirror.RadialMirrorSettings r = modifierSettings.getRadialMirrorSettings();
            this.buttonRadialMirrorEnabled.setIsChecked(r.enabled);
            this.textRadialMirrorPosX.setNumber(r.position.f_82479_);
            this.textRadialMirrorPosY.setNumber(r.position.f_82480_);
            this.textRadialMirrorPosZ.setNumber(r.position.f_82481_);
            this.textRadialMirrorSlices.setNumber(r.slices);
            this.buttonRadialMirrorAlternate.setIsChecked(r.alternate);
            this.textRadialMirrorRadius.setNumber(r.radius);
            this.drawLines = r.drawLines;
            this.drawPlanes = r.drawPlanes;
            this.buttonDrawLines.setUseAlternateIcon(this.drawLines);
            this.buttonDrawPlanes.setUseAlternateIcon(this.drawPlanes);
            this.buttonDrawLines.setTooltip((Component)new TextComponent(this.drawLines ? "Hide lines" : "Show lines"));
            this.buttonDrawPlanes.setTooltip((Component)new TextComponent(this.drawPlanes ? "Hide area" : "Show area"));
            if (this.textRadialMirrorPosX.getNumber() == Math.floor(this.textRadialMirrorPosX.getNumber())) {
                this.toggleOdd = false;
                this.buttonToggleOdd.setTooltip(Arrays.asList(new TextComponent("Set radial mirror position to middle of block"), new TextComponent("for odd numbered builds")));
            } else {
                this.toggleOdd = true;
                this.buttonToggleOdd.setTooltip(Arrays.asList(new TextComponent("Set radial mirror position to corner of block"), new TextComponent("for even numbered builds")));
            }
            this.buttonToggleOdd.setUseAlternateIcon(this.toggleOdd);
        }
        renderables.addAll(this.radialMirrorButtonList);
        renderables.addAll(this.radialMirrorIconButtonList);
        this.setCollapsed(!this.buttonRadialMirrorEnabled.isChecked());
    }

    @Override
    public void updateScreen() {
        this.radialMirrorNumberFieldList.forEach(GuiNumberField::update);
    }

    @Override
    public void drawEntry(PoseStack ms, int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partialTicks) {
        int yy = y;
        int offset = 8;
        this.buttonRadialMirrorEnabled.m_6305_(ms, mouseX, mouseY, partialTicks);
        if (this.buttonRadialMirrorEnabled.isChecked()) {
            this.buttonRadialMirrorEnabled.f_93621_ = yy;
            this.font.m_92883_(ms, "Radial mirror enabled", (float)(this.left + offset), (float)(yy + 2), 0xFFFFFF);
            yy = y + 18;
            this.font.m_92883_(ms, "Position", (float)(this.left + offset), (float)(yy + 5), 0xFFFFFF);
            this.font.m_92883_(ms, "X", (float)(this.left + 40 + offset), (float)(yy + 5), 0xFFFFFF);
            this.textRadialMirrorPosX.y = yy;
            this.font.m_92883_(ms, "Y", (float)(this.left + 120 + offset), (float)(yy + 5), 0xFFFFFF);
            this.textRadialMirrorPosY.y = yy;
            this.font.m_92883_(ms, "Z", (float)(this.left + 200 + offset), (float)(yy + 5), 0xFFFFFF);
            this.textRadialMirrorPosZ.y = yy;
            yy = y + 50;
            this.font.m_92883_(ms, "Slices", (float)(this.left + offset), (float)(yy + 2), 0xFFFFFF);
            this.textRadialMirrorSlices.y = yy - 3;
            this.font.m_92883_(ms, "Radius", (float)(this.left + 176 + offset), (float)(yy + 2), 0xFFFFFF);
            this.textRadialMirrorRadius.y = yy - 3;
            this.buttonCurrentPosition.f_93621_ = yy = y + 72;
            this.buttonToggleOdd.f_93621_ = yy;
            this.buttonDrawLines.f_93621_ = yy;
            this.buttonDrawPlanes.f_93621_ = yy;
            this.buttonRadialMirrorAlternate.f_93621_ = yy = y + 76;
            this.radialMirrorButtonList.forEach(button -> button.m_6305_(ms, mouseX, mouseY, partialTicks));
            this.radialMirrorIconButtonList.forEach(button -> button.m_6305_(ms, mouseX, mouseY, partialTicks));
            this.radialMirrorNumberFieldList.forEach(numberField -> numberField.drawNumberField(ms, mouseX, mouseY, partialTicks));
        } else {
            this.buttonRadialMirrorEnabled.f_93621_ = yy;
            this.font.m_92883_(ms, "Radial mirror disabled", (float)(this.left + offset), (float)(yy + 2), 0x999999);
        }
    }

    @Override
    public void drawTooltip(PoseStack ms, Screen guiScreen, int mouseX, int mouseY) {
        if (this.buttonRadialMirrorEnabled.isChecked()) {
            this.radialMirrorIconButtonList.forEach(iconButton -> iconButton.drawTooltip(ms, this.scrollPane.parent, mouseX, mouseY));
            this.radialMirrorNumberFieldList.forEach(numberField -> numberField.drawTooltip(ms, this.scrollPane.parent, mouseX, mouseY));
        }
    }

    @Override
    public boolean charTyped(char typedChar, int keyCode) {
        super.charTyped(typedChar, keyCode);
        for (GuiNumberField numberField : this.radialMirrorNumberFieldList) {
            numberField.charTyped(typedChar, keyCode);
        }
        return true;
    }

    @Override
    public boolean mousePressed(int slotIndex, int mouseX, int mouseY, int mouseEvent, int relativeX, int relativeY) {
        boolean insideRadialMirrorEnabledLabel;
        this.radialMirrorNumberFieldList.forEach(numberField -> numberField.mouseClicked(mouseX, mouseY, mouseEvent));
        boolean bl = insideRadialMirrorEnabledLabel = mouseX >= this.left && mouseX < this.right && relativeY >= -2 && relativeY < 12;
        if (insideRadialMirrorEnabledLabel) {
            this.buttonRadialMirrorEnabled.m_7435_(this.mc.m_91106_());
            this.buttonRadialMirrorEnabled.m_5716_(mouseX, mouseY);
        }
        return true;
    }

    public RadialMirror.RadialMirrorSettings getRadialMirrorSettings() {
        boolean radialMirrorEnabled = this.buttonRadialMirrorEnabled.isChecked();
        Vec3 radialMirrorPos = new Vec3(0.0, 64.0, 0.0);
        try {
            radialMirrorPos = new Vec3(this.textRadialMirrorPosX.getNumber(), this.textRadialMirrorPosY.getNumber(), this.textRadialMirrorPosZ.getNumber());
        }
        catch (NullPointerException | NumberFormatException ex) {
            EffortlessBuilding.log((Player)this.mc.f_91074_, "Radial mirror position not a valid number.");
        }
        int radialMirrorSlices = 4;
        try {
            radialMirrorSlices = (int)this.textRadialMirrorSlices.getNumber();
        }
        catch (NullPointerException | NumberFormatException ex) {
            EffortlessBuilding.log((Player)this.mc.f_91074_, "Radial mirror slices not a valid number.");
        }
        boolean radialMirrorAlternate = this.buttonRadialMirrorAlternate.isChecked();
        int radialMirrorRadius = 50;
        try {
            radialMirrorRadius = (int)this.textRadialMirrorRadius.getNumber();
        }
        catch (NullPointerException | NumberFormatException ex) {
            EffortlessBuilding.log((Player)this.mc.f_91074_, "Mirror radius not a valid number.");
        }
        return new RadialMirror.RadialMirrorSettings(radialMirrorEnabled, radialMirrorPos, radialMirrorSlices, radialMirrorAlternate, radialMirrorRadius, this.drawLines, this.drawPlanes);
    }

    @Override
    protected String getName() {
        return "Radial mirror";
    }

    @Override
    protected int getExpandedHeight() {
        return 100;
    }
}

