/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.helper;

import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;
import nl.requios.effortlessbuilding.BuildConfig;
import nl.requios.effortlessbuilding.buildmodifier.ModifierSettingsManager;
import nl.requios.effortlessbuilding.compatibility.CompatHelper;

public class SurvivalHelper {
    private static final Tag.Named<Block> NEEDS_NETHERITE_TOOL = BlockTags.m_13116_((String)"forge:needs_netherite_tool");

    public static boolean placeBlock(Level world, Player player, BlockPos pos, BlockState blockState, ItemStack origstack, Direction facing, Vec3 hitVec, boolean skipPlaceCheck, boolean skipCollisionCheck, boolean playSound) {
        if (!world.m_46749_(pos)) {
            return false;
        }
        ItemStack itemstack = origstack;
        if (blockState.m_60795_() || itemstack.m_41619_()) {
            SurvivalHelper.dropBlock(world, player, pos);
            world.m_7471_(pos, false);
            return true;
        }
        if (CompatHelper.isItemBlockProxy(itemstack)) {
            itemstack = CompatHelper.getItemBlockByState(itemstack, blockState);
        }
        if (!(itemstack.m_41720_() instanceof BlockItem)) {
            return false;
        }
        Block block = ((BlockItem)itemstack.m_41720_()).m_40614_();
        if (skipPlaceCheck || SurvivalHelper.canPlace(world, player, pos, blockState, itemstack, skipCollisionCheck, facing.m_122424_())) {
            SurvivalHelper.dropBlock(world, player, pos);
            if (!world.m_7731_(pos, blockState, 3)) {
                return false;
            }
            BlockItem.m_40582_((Level)world, (Player)player, (BlockPos)pos, (ItemStack)itemstack);
            block.m_6402_(world, pos, blockState, (LivingEntity)player, itemstack);
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10591_.m_59469_((ServerPlayer)player, pos, itemstack);
            }
            BlockState afterState = world.m_8055_(pos);
            if (playSound) {
                SoundType soundtype = afterState.m_60734_().getSoundType(afterState, (LevelReader)world, pos, (Entity)player);
                world.m_5594_(null, pos, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
            }
            if (!player.m_7500_() && Block.m_49814_((Item)itemstack.m_41720_()) == block) {
                CompatHelper.shrinkStack(origstack, itemstack, player);
            }
            return true;
        }
        return false;
    }

    public static boolean breakBlock(Level world, Player player, BlockPos pos, boolean skipChecks) {
        if (!world.m_46749_(pos) && !world.m_46859_(pos)) {
            return false;
        }
        if (skipChecks || SurvivalHelper.canBreak(world, player, pos)) {
            SurvivalHelper.dropBlock(world, player, pos);
            player.m_21205_().m_41686_(world, world.m_8055_(pos), pos, player);
            world.m_7471_(pos, false);
            return true;
        }
        return false;
    }

    public static void dropBlock(Level world, Player player, BlockPos pos) {
        if (player.m_7500_()) {
            return;
        }
        BlockState blockState = world.m_8055_(pos);
        Block block = blockState.m_60734_();
        block.m_6240_(world, player, pos, blockState, world.m_7702_(pos), player.m_21205_());
    }

    public static boolean canPlace(Level world, Player player, BlockPos pos, BlockState newBlockState, ItemStack itemStack, boolean skipCollisionCheck, Direction sidePlacedOn) {
        if (!(itemStack.m_41720_() instanceof BlockItem) || Block.m_49814_((Item)itemStack.m_41720_()) != newBlockState.m_60734_()) {
            return false;
        }
        Block block = ((BlockItem)itemStack.m_41720_()).m_40614_();
        return !itemStack.m_41619_() && SurvivalHelper.canPlayerEdit(player, world, pos, itemStack) && SurvivalHelper.mayPlace(world, block, newBlockState, pos, skipCollisionCheck, sidePlacedOn, (Entity)player) && SurvivalHelper.canReplace(world, player, pos);
    }

    private static boolean canReplace(Level world, Player player, BlockPos pos) {
        if (player.m_7500_()) {
            return true;
        }
        BlockState state = world.m_8055_(pos);
        int miningLevel = (Integer)BuildConfig.survivalBalancers.quickReplaceMiningLevel.get();
        switch (miningLevel) {
            case -1: {
                return !state.m_60834_();
            }
            case 0: {
                return !state.m_60620_((Tag)BlockTags.f_144286_) && !state.m_60620_((Tag)BlockTags.f_144285_) && !state.m_60620_((Tag)BlockTags.f_144284_) && !state.m_60620_(NEEDS_NETHERITE_TOOL);
            }
            case 1: {
                return !state.m_60620_((Tag)BlockTags.f_144285_) && !state.m_60620_((Tag)BlockTags.f_144284_) && !state.m_60620_(NEEDS_NETHERITE_TOOL);
            }
            case 2: {
                return !state.m_60620_((Tag)BlockTags.f_144284_) && !state.m_60620_(NEEDS_NETHERITE_TOOL);
            }
            case 3: {
                return !state.m_60620_(NEEDS_NETHERITE_TOOL);
            }
            case 4: {
                return true;
            }
        }
        return false;
    }

    private static boolean canPlayerEdit(Player player, Level world, BlockPos pos, ItemStack stack) {
        if (!world.m_7966_(player, pos)) {
            return false;
        }
        if (player.m_150110_().f_35938_) {
            return true;
        }
        BlockInWorld blockworldstate = new BlockInWorld((LevelReader)world, pos, false);
        return stack.m_41723_(world.m_5999_(), blockworldstate);
    }

    private static boolean mayPlace(Level world, Block blockIn, BlockState newBlockState, BlockPos pos, boolean skipCollisionCheck, Direction sidePlacedOn, @Nullable Entity placer) {
        VoxelShape voxelShape;
        BlockState iblockstate1 = world.m_8055_(pos);
        VoxelShape voxelShape2 = voxelShape = skipCollisionCheck ? null : blockIn.m_49966_().m_60812_((BlockGetter)world, pos);
        if (voxelShape != null && !world.m_5450_(placer, voxelShape)) {
            return false;
        }
        if (placer != null && SurvivalHelper.doesBecomeDoubleSlab((Player)placer, pos, sidePlacedOn)) {
            return true;
        }
        if (iblockstate1 == newBlockState) {
            return false;
        }
        if (iblockstate1.m_60767_() == Material.f_76312_ && blockIn == Blocks.f_50322_) {
            return true;
        }
        if (placer instanceof Player && ModifierSettingsManager.getModifierSettings((Player)placer).doQuickReplace()) {
            return true;
        }
        return iblockstate1.m_60767_().m_76336_();
    }

    public static boolean canBreak(Level world, Player player, BlockPos pos) {
        BlockState blockState = world.m_8055_(pos);
        if (!world.m_6425_(pos).m_76178_()) {
            return false;
        }
        if (player.m_7500_()) {
            return true;
        }
        return ForgeEventFactory.doPlayerHarvestCheck((Player)player, (BlockState)blockState, (boolean)true);
    }

    public static boolean doesBecomeDoubleSlab(Player player, BlockPos pos, Direction facing) {
        BlockState placedBlockState = player.f_19853_.m_8055_(pos);
        ItemStack itemstack = player.m_21120_(InteractionHand.MAIN_HAND);
        if (CompatHelper.isItemBlockProxy(itemstack)) {
            itemstack = CompatHelper.getItemBlockFromStack(itemstack);
        }
        if (itemstack.m_41619_() || !(itemstack.m_41720_() instanceof BlockItem) || !(((BlockItem)itemstack.m_41720_()).m_40614_() instanceof SlabBlock)) {
            return false;
        }
        SlabBlock heldSlab = (SlabBlock)((BlockItem)itemstack.m_41720_()).m_40614_();
        if (placedBlockState.m_60734_() == heldSlab) {
            // empty if block
        }
        return false;
    }
}

